/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import org.apache.ignite.configuration.ConfigurationProperty;
import org.apache.ignite.configuration.NamedConfigurationTree;
import org.apache.ignite.configuration.NamedListChange;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite.internal.configuration.ConfigurationListenerHolder;
import org.apache.ignite.internal.configuration.DynamicConfiguration;
import org.apache.ignite.internal.configuration.DynamicConfigurationChanger;
import org.apache.ignite.internal.configuration.direct.DirectNamedListProxy;
import org.apache.ignite.internal.configuration.direct.KeyPathNode;
import org.apache.ignite.internal.configuration.tree.NamedListNode;
import org.jetbrains.annotations.Nullable;

public class NamedListConfiguration<T extends ConfigurationProperty<VIEWT>, VIEWT, CHANGET extends VIEWT>
extends DynamicConfiguration<NamedListView<VIEWT>, NamedListChange<VIEWT, CHANGET>>
implements NamedConfigurationTree<T, VIEWT, CHANGET> {
    private final ConfigurationListenerHolder<ConfigurationNamedListListener<VIEWT>> extendedListeners = new ConfigurationListenerHolder();
    private final BiFunction<List<String>, String, T> cfgCreator;
    private BiFunction<List<KeyPathNode>, DynamicConfigurationChanger, T> directProxyCreator;
    private final T anyConfig;
    private volatile Map<String, T> notificationCache = Collections.emptyMap();

    public NamedListConfiguration(List<String> prefix, String key, RootKey<?, ?> rootKey, DynamicConfigurationChanger changer, boolean listenOnly, BiFunction<List<String>, String, T> cfgCreator, BiFunction<List<KeyPathNode>, DynamicConfigurationChanger, T> directProxyCreator, T anyConfig) {
        super(prefix, key, rootKey, changer, listenOnly);
        this.cfgCreator = cfgCreator;
        this.directProxyCreator = directProxyCreator;
        this.anyConfig = anyConfig;
    }

    @Nullable
    public T get(String name) {
        DynamicConfiguration<?, ?> config = this.getConfig(name);
        return (T)(config == null ? null : config.specificConfigTree());
    }

    @Nullable
    public T get(UUID internalId) {
        NamedListNode value = (NamedListNode)this.value();
        return this.get(value.keyByInternalId(internalId));
    }

    @Nullable
    public DynamicConfiguration<?, ?> getConfig(String name) {
        this.refreshValue();
        return (DynamicConfiguration)this.members.get(name);
    }

    public List<UUID> internalIds() {
        NamedListView<VIEWT> value = this.value();
        return List.copyOf(((NamedListNode)value).internalIds());
    }

    @Override
    protected synchronized void beforeRefreshValue(NamedListView<VIEWT> newValue, @Nullable NamedListView<VIEWT> oldValue) {
        Map oldValues = this.members;
        LinkedHashMap<String, ConfigurationProperty> newValues = new LinkedHashMap<String, ConfigurationProperty>();
        for (String key : newValue.namedListKeys()) {
            ConfigurationProperty oldElement = (ConfigurationProperty)oldValues.get(key);
            if (oldElement != null) {
                newValues.put(key, oldElement);
                continue;
            }
            newValues.put(key, (ConfigurationProperty)this.cfgCreator.apply(this.keys, key));
        }
        this.members = newValues;
    }

    @Override
    public Map<String, ConfigurationProperty<?>> touchMembers() {
        Map<String, T> res = this.notificationCache;
        this.refreshValue();
        this.notificationCache = this.members;
        return Collections.unmodifiableMap(res);
    }

    public void listenElements(ConfigurationNamedListListener<VIEWT> listener) {
        this.extendedListeners.addListener(listener, this.changer.notificationCount());
    }

    public void stopListenElements(ConfigurationNamedListListener<VIEWT> listener) {
        this.extendedListeners.removeListener(listener);
    }

    public Iterator<ConfigurationNamedListListener<VIEWT>> extendedListeners(long notificationNumber) {
        return this.extendedListeners.listeners(notificationNumber);
    }

    public T any() {
        return this.anyConfig;
    }

    @Override
    public Class<?> configType() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Class<?> @Nullable [] extensionConfigTypes() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    @Nullable
    public Class<?> polymorphicInstanceConfigType() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public NamedListView<VIEWT> value() {
        return (NamedListView)this.refreshValue();
    }

    public NamedConfigurationTree<T, VIEWT, CHANGET> directProxy() {
        if (this.listenOnly) {
            throw this.listenOnlyException();
        }
        assert (this.directProxyCreator != null);
        return new DirectNamedListProxy(this.keyPath(), this.changer, this.directProxyCreator);
    }
}

