/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.raft.snapshot;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.raft.storage.SnapshotStorageFactory;
import org.apache.ignite.internal.table.distributed.raft.snapshot.PartitionAccess;
import org.apache.ignite.internal.table.distributed.raft.snapshot.PartitionSnapshotStorage;
import org.apache.ignite.internal.table.distributed.raft.snapshot.outgoing.OutgoingSnapshotsManager;
import org.apache.ignite.internal.table.distributed.raft.snapshot.outgoing.SnapshotMetaUtils;
import org.apache.ignite.raft.jraft.entity.RaftOutter;
import org.apache.ignite.raft.jraft.option.RaftOptions;
import org.jetbrains.annotations.Nullable;

public class PartitionSnapshotStorageFactory
implements SnapshotStorageFactory {
    private final TopologyService topologyService;
    private final OutgoingSnapshotsManager outgoingSnapshotsManager;
    private final PartitionAccess partition;
    private final CatalogService catalogService;
    @Nullable
    private final RaftOutter.SnapshotMeta startupSnapshotMeta;
    private final Executor incomingSnapshotsExecutor;

    public PartitionSnapshotStorageFactory(TopologyService topologyService, OutgoingSnapshotsManager outgoingSnapshotsManager, PartitionAccess partition, CatalogService catalogService, Executor incomingSnapshotsExecutor) {
        this.topologyService = topologyService;
        this.outgoingSnapshotsManager = outgoingSnapshotsManager;
        this.partition = partition;
        this.catalogService = catalogService;
        this.incomingSnapshotsExecutor = incomingSnapshotsExecutor;
        long lastIncludedRaftIndex = partition.minLastAppliedIndex();
        long lastIncludedRaftTerm = partition.minLastAppliedTerm();
        int lastCatalogVersionAtStart = catalogService.latestCatalogVersion();
        this.startupSnapshotMeta = lastIncludedRaftIndex == 0L ? null : SnapshotMetaUtils.snapshotMetaAt(lastIncludedRaftIndex, lastIncludedRaftTerm, Objects.requireNonNull(partition.committedGroupConfiguration()), lastCatalogVersionAtStart, this.collectNextRowIdToBuildIndexesAtStart(lastCatalogVersionAtStart), partition.leaseStartTime(), partition.primaryReplicaNodeId(), partition.primaryReplicaNodeName());
    }

    @Nullable
    public PartitionSnapshotStorage createSnapshotStorage(String uri, RaftOptions raftOptions) {
        return new PartitionSnapshotStorage(this.topologyService, this.outgoingSnapshotsManager, uri, raftOptions, this.partition, this.catalogService, this.startupSnapshotMeta, this.incomingSnapshotsExecutor);
    }

    private Map<Integer, UUID> collectNextRowIdToBuildIndexesAtStart(int lastCatalogVersionAtStart) {
        return SnapshotMetaUtils.collectNextRowIdToBuildIndexes(this.catalogService, this.partition, lastCatalogVersionAtStart);
    }
}

