/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.executor;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.internal.compute.ComputeJobDataHolder;
import org.apache.ignite.internal.compute.MarshallerProvider;
import org.apache.ignite.internal.compute.queue.QueueExecution;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.marshalling.Marshaller;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

public class JobExecutionInternal<R>
implements MarshallerProvider<R> {
    private final QueueExecution<ComputeJobDataHolder> execution;
    private final AtomicBoolean isInterrupted;
    private final Marshaller<R, byte[]> marshaller;
    private final boolean marshalResult;
    private final ClusterNode publicLocalNode;

    JobExecutionInternal(QueueExecution<ComputeJobDataHolder> execution, AtomicBoolean isInterrupted, @Nullable Marshaller<R, byte[]> marshaller, boolean marshalResult, InternalClusterNode localNode) {
        this.execution = execution;
        this.isInterrupted = isInterrupted;
        this.marshaller = marshaller;
        this.marshalResult = marshalResult;
        this.publicLocalNode = localNode.toPublicNode();
    }

    public CompletableFuture<ComputeJobDataHolder> resultAsync() {
        return this.execution.resultAsync();
    }

    @Nullable
    public JobState state() {
        return this.execution.state();
    }

    public boolean cancel() {
        this.isInterrupted.set(true);
        return this.execution.cancel();
    }

    public boolean changePriority(int newPriority) {
        return this.execution.changePriority(newPriority);
    }

    @Override
    @Nullable
    public Marshaller<R, byte[]> resultMarshaller() {
        return this.marshaller;
    }

    @Override
    public boolean marshalResult() {
        return this.marshalResult;
    }

    public ClusterNode node() {
        return this.publicLocalNode;
    }
}

