/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.raft.jraft.rpc.AppendEntriesResponseImpl;
import org.apache.ignite3.raft.jraft.rpc.RpcRequests;

class AppendEntriesResponseSerializer
implements MessageSerializer<RpcRequests.AppendEntriesResponse> {
    public static final AppendEntriesResponseSerializer INSTANCE = new AppendEntriesResponseSerializer();

    private AppendEntriesResponseSerializer() {
    }

    @Override
    public boolean writeMessage(RpcRequests.AppendEntriesResponse msg, MessageWriter writer) throws MessageMappingException {
        AppendEntriesResponseImpl message = (AppendEntriesResponseImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)8)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeInt("errorCode", message.errorCode());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeString("errorMsg", message.errorMsg());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeLong("lastLogIndex", message.lastLogIndex());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeString("leaderId", message.leaderId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeBoxedLong("maxObservableSafeTimeViolatedValue", message.maxObservableSafeTimeViolatedValue());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeBoolean("success", message.success());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                boolean written = writer.writeLong("term", message.term());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                boolean written = writer.writeHybridTimestamp("timestamp", message.timestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

