/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.memory;

import com.google.protobuf.ByteString;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bifromq.basekv.localengine.IKVSpaceIterator;
import org.apache.bifromq.basekv.proto.Boundary;

class InMemKVSpaceIterator
implements IKVSpaceIterator {
    private final Boundary boundary;
    private final AtomicReference<NavigableMap<ByteString, ByteString>> currentEpoch = new AtomicReference();
    private final CloseListener closeListener;
    private Map.Entry<ByteString, ByteString> currentEntry;
    private NavigableMap<ByteString, ByteString> dataSource;

    public InMemKVSpaceIterator(NavigableMap<ByteString, ByteString> epoch, Boundary boundary) {
        this(epoch, boundary, iterator -> {});
    }

    public InMemKVSpaceIterator(NavigableMap<ByteString, ByteString> epoch, Boundary boundary, CloseListener closeListener) {
        this.boundary = boundary;
        this.closeListener = closeListener;
        this.refresh(epoch);
    }

    public ByteString key() {
        return this.currentEntry.getKey();
    }

    public ByteString value() {
        return this.currentEntry.getValue();
    }

    public boolean isValid() {
        return this.currentEntry != null;
    }

    public void next() {
        this.currentEntry = this.dataSource().higherEntry(this.currentEntry.getKey());
    }

    public void prev() {
        this.currentEntry = this.dataSource().lowerEntry(this.currentEntry.getKey());
    }

    public void seekToFirst() {
        if (this.dataSource().isEmpty()) {
            this.currentEntry = null;
            return;
        }
        this.currentEntry = this.dataSource().firstEntry();
    }

    public void seekToLast() {
        if (this.dataSource().isEmpty()) {
            this.currentEntry = null;
            return;
        }
        this.currentEntry = this.dataSource().lastEntry();
    }

    public void seek(ByteString target) {
        this.currentEntry = this.dataSource().ceilingEntry(target);
    }

    public void seekForPrev(ByteString target) {
        this.currentEntry = this.dataSource().floorEntry(target);
    }

    public void refresh(NavigableMap<ByteString, ByteString> epoch) {
        this.currentEntry = null;
        this.currentEpoch.set(epoch);
        NavigableMap<ByteString, ByteString> data = this.currentEpoch.get();
        this.dataSource = !this.boundary.hasStartKey() && !this.boundary.hasEndKey() ? data : (!this.boundary.hasStartKey() ? data.headMap(this.boundary.getEndKey(), false) : (!this.boundary.hasEndKey() ? data.tailMap(this.boundary.getStartKey(), true) : data.subMap(this.boundary.getStartKey(), true, this.boundary.getEndKey(), false)));
    }

    private NavigableMap<ByteString, ByteString> dataSource() {
        return this.dataSource;
    }

    public void close() {
        this.currentEntry = null;
        this.closeListener.onClose(this);
    }

    static interface CloseListener {
        public void onClose(InMemKVSpaceIterator var1);
    }
}

