/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.starter.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ClusterDomainUtil {
    public static CompletableFuture<InetAddress[]> resolve(final String clusterDomainName, final Duration timeout) {
        final CompletableFuture<InetAddress[]> future = new CompletableFuture<InetAddress[]>();
        final Executor delayedExecutor = CompletableFuture.delayedExecutor(timeout.toNanos() / 3L, TimeUnit.NANOSECONDS);
        Runnable resolveTask = new Runnable(){
            private final long startTime = System.nanoTime();

            @Override
            public void run() {
                if (!future.isDone()) {
                    try {
                        InetAddress[] addresses = InetAddress.getAllByName(clusterDomainName);
                        if (addresses.length <= 0) {
                            throw new UnknownHostException("No addresses resolved for " + clusterDomainName);
                        }
                        future.complete(addresses);
                    }
                    catch (UnknownHostException e) {
                        if (System.nanoTime() - this.startTime > timeout.toNanos()) {
                            future.completeExceptionally(new UnknownHostException("Timeout while resolving domain name to a list of addresses"));
                        }
                        CompletableFuture.runAsync(this, delayedExecutor);
                    }
                }
            }
        };
        CompletableFuture.runAsync(resolveTask);
        return future;
    }
}

