/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.client.scheduler;

import com.google.protobuf.ByteString;
import java.util.Optional;
import lombok.Generated;
import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.basekv.client.KVRangeRouterUtil;
import org.apache.bifromq.basekv.client.KVRangeSetting;
import org.apache.bifromq.basekv.client.scheduler.BatchMutationCall;
import org.apache.bifromq.basekv.client.scheduler.BatchMutationCallBuilderFactory;
import org.apache.bifromq.basekv.client.scheduler.IBatchMutationCallBuilder;
import org.apache.bifromq.basekv.client.scheduler.MutationCallBatcherKey;
import org.apache.bifromq.basescheduler.BatchCallScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MutationCallScheduler<ReqT, RespT, BatchCallT extends BatchMutationCall<ReqT, RespT>>
extends BatchCallScheduler<ReqT, RespT, MutationCallBatcherKey> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MutationCallScheduler.class);
    protected final IBaseKVStoreClient storeClient;

    public MutationCallScheduler(IBatchMutationCallBuilder<ReqT, RespT, BatchCallT> batchCallBuilder, long maxBurstLatency, IBaseKVStoreClient storeClient) {
        super(new BatchMutationCallBuilderFactory<ReqT, RespT, BatchCallT>(storeClient, batchCallBuilder), maxBurstLatency);
        this.storeClient = storeClient;
    }

    protected final Optional<MutationCallBatcherKey> find(ReqT call) {
        Optional<KVRangeSetting> rangeSetting = KVRangeRouterUtil.findByKey(this.rangeKey(call), this.storeClient.latestEffectiveRouter());
        return rangeSetting.map(setting -> new MutationCallBatcherKey(setting.id(), setting.leader(), setting.ver()));
    }

    protected abstract ByteString rangeKey(ReqT var1);
}

