/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.retain.server.scheduler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.bifromq.basekv.client.KVRangeSetting;
import org.apache.bifromq.retain.rpc.proto.MatchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchMatchCallHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchMatchCallHelper.class);

    BatchMatchCallHelper() {
    }

    static CompletableFuture<Map<String, MatchResult>> parallelMatch(long reqId, long now, Map<KVRangeSetting, Set<String>> rangeAssignment, IRetainMatcher matcher) {
        ArrayList<CompletableFuture<Map<String, MatchResult>>> futures = new ArrayList<CompletableFuture<Map<String, MatchResult>>>(rangeAssignment.size());
        for (KVRangeSetting rangeSetting : rangeAssignment.keySet()) {
            Set<String> topicFilters = rangeAssignment.get(rangeSetting);
            Map<String, Integer> topicFiltersMap = topicFilters.stream().collect(Collectors.toMap(k -> k, v -> 1));
            futures.add(matcher.match(reqId, now, topicFiltersMap, rangeSetting));
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).thenApply(v -> futures.stream().map(CompletableFuture::join).reduce(new HashMap(), (acc, m) -> {
            acc.putAll(m);
            return acc;
        }));
    }

    static CompletableFuture<Map<String, MatchResult>> serialMatch(long reqId, long now, Map<KVRangeSetting, Set<String>> rangeAssignment, int limit, IRetainMatcher matcher) {
        HashMap aggregatedMap = new HashMap();
        for (Set<String> topicFilters : rangeAssignment.values()) {
            topicFilters.forEach(tf -> aggregatedMap.putIfAbsent(tf, new LinkedList()));
        }
        CompletionStage future = CompletableFuture.completedFuture(aggregatedMap);
        for (KVRangeSetting rangeSetting : rangeAssignment.keySet()) {
            future = future.thenCompose(aggregated -> {
                HashMap<String, Integer> remainingFilters = new HashMap<String, Integer>();
                for (String tf : (Set)rangeAssignment.get(rangeSetting)) {
                    List retainMsgList = (List)aggregated.get(tf);
                    if (retainMsgList.size() >= limit) continue;
                    remainingFilters.put(tf, limit - retainMsgList.size());
                }
                if (remainingFilters.isEmpty()) {
                    return CompletableFuture.completedFuture(aggregated);
                }
                return matcher.match(reqId, now, remainingFilters, rangeSetting).thenApply(result -> {
                    for (Map.Entry entry : result.entrySet()) {
                        String topicFilter = (String)entry.getKey();
                        MatchResult newResult = (MatchResult)entry.getValue();
                        aggregated.computeIfPresent(topicFilter, (k, v) -> {
                            for (int i = 0; i < newResult.getMessagesCount(); ++i) {
                                if (v.size() >= limit) continue;
                                v.add(newResult.getMessages(i));
                            }
                            return v;
                        });
                    }
                    return aggregated;
                });
            });
        }
        return future.thenApply(v -> {
            HashMap result = new HashMap();
            v.forEach((k, v1) -> result.put(k, MatchResult.newBuilder().addAllMessages((Iterable)v1).build()));
            return result;
        });
    }

    static interface IRetainMatcher {
        public CompletableFuture<Map<String, MatchResult>> match(long var1, long var3, Map<String, Integer> var5, KVRangeSetting var6);
    }
}

