/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.range;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.observers.DisposableObserver;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bifromq.base.util.CascadeCancelCompletableFuture;
import org.apache.bifromq.basekv.proto.KVPair;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.proto.KVRangeMessage;
import org.apache.bifromq.basekv.proto.SaveSnapshotDataReply;
import org.apache.bifromq.basekv.proto.SaveSnapshotDataRequest;
import org.apache.bifromq.basekv.store.range.IKVRangeMessenger;
import org.apache.bifromq.basekv.store.range.IKVRangeMetricManager;
import org.apache.bifromq.basekv.store.range.IKVRangeSnapshotReceiver;
import org.apache.bifromq.basekv.utils.KVRangeIdUtil;
import org.slf4j.Logger;

class KVRangeSnapshotReceiver
implements IKVRangeSnapshotReceiver {
    private final Logger log;
    private final String sessionId;
    private final IKVRangeMessenger messenger;
    private final IKVRangeMetricManager metricManager;
    private final Executor executor;
    private final int idleTimeSec;
    private final KVRangeId sourceRangeId;
    private final String sourceStoreId;

    public KVRangeSnapshotReceiver(String sessionId, KVRangeId sourceRangeId, String sourceStoreId, IKVRangeMessenger messenger, IKVRangeMetricManager metricManager, Executor executor, int idleTimeSec, Logger log) {
        this.sessionId = sessionId;
        this.sourceRangeId = sourceRangeId;
        this.sourceStoreId = sourceStoreId;
        this.messenger = messenger;
        this.metricManager = metricManager;
        this.executor = executor;
        this.idleTimeSec = idleTimeSec;
        this.log = log;
    }

    @Override
    public CompletableFuture<IKVRangeSnapshotReceiver.Result> start(final IKVRangeSnapshotReceiver.ReceiveListener listener) {
        final CompletableFuture onDone = new CompletableFuture();
        final AtomicLong totalEntries = new AtomicLong();
        final AtomicLong totalBytes = new AtomicLong();
        try {
            DisposableObserver observer = (DisposableObserver)this.messenger.receive().filter(m -> m.hasSaveSnapshotDataRequest() && m.getHostStoreId().equals(this.sourceStoreId) && m.getSaveSnapshotDataRequest().getSessionId().equals(this.sessionId)).timeout((long)this.idleTimeSec, TimeUnit.SECONDS, Schedulers.from((Executor)this.executor)).observeOn(Schedulers.from((Executor)this.executor)).subscribeWith((Observer)new DisposableObserver<KVRangeMessage>(){

                public void onNext(@NonNull KVRangeMessage m) {
                    SaveSnapshotDataRequest request = m.getSaveSnapshotDataRequest();
                    try {
                        switch (request.getFlag()) {
                            case More: 
                            case End: {
                                int thisBytes = 0;
                                int thisEntries = 0;
                                for (KVPair kv : request.getKvList()) {
                                    thisBytes += kv.getKey().size();
                                    thisBytes += kv.getValue().size();
                                    ++thisEntries;
                                    listener.onReceive(kv.getKey(), kv.getValue());
                                }
                                KVRangeSnapshotReceiver.this.metricManager.reportRestore(thisBytes);
                                totalEntries.addAndGet(thisEntries);
                                totalBytes.addAndGet(thisBytes);
                                if (request.getFlag() == SaveSnapshotDataRequest.Flag.End) {
                                    if (!onDone.isCancelled()) {
                                        this.dispose();
                                        onDone.complete(new IKVRangeSnapshotReceiver.Result(IKVRangeSnapshotReceiver.Code.DONE, totalEntries.get(), totalBytes.get()));
                                        KVRangeSnapshotReceiver.this.log.info("Finish data receiving: rangeId={}, storeId={}, session={}", new Object[]{KVRangeIdUtil.toString((KVRangeId)KVRangeSnapshotReceiver.this.sourceRangeId), KVRangeSnapshotReceiver.this.sourceStoreId, KVRangeSnapshotReceiver.this.sessionId});
                                    } else {
                                        this.dispose();
                                        KVRangeSnapshotReceiver.this.log.info("Receiver canceled: session={}", (Object)KVRangeSnapshotReceiver.this.sessionId);
                                    }
                                }
                                KVRangeSnapshotReceiver.this.log.debug("Send reply: rangeId={}, storeId={}, session={}", new Object[]{KVRangeIdUtil.toString((KVRangeId)KVRangeSnapshotReceiver.this.sourceRangeId), KVRangeSnapshotReceiver.this.sourceStoreId, KVRangeSnapshotReceiver.this.sessionId});
                                KVRangeSnapshotReceiver.this.messenger.send(KVRangeMessage.newBuilder().setRangeId(KVRangeSnapshotReceiver.this.sourceRangeId).setHostStoreId(KVRangeSnapshotReceiver.this.sourceStoreId).setSaveSnapshotDataReply(SaveSnapshotDataReply.newBuilder().setReqId(request.getReqId()).setSessionId(request.getSessionId()).setResult(SaveSnapshotDataReply.Result.OK).build()).build());
                                break;
                            }
                            case NotFound: {
                                onDone.complete(new IKVRangeSnapshotReceiver.Result(IKVRangeSnapshotReceiver.Code.NOT_FOUND, 0L, 0L));
                                this.dispose();
                                break;
                            }
                            default: {
                                KVRangeSnapshotReceiver.this.log.debug("Failed to receive data: rangeId={}, storeId={}, session={}", new Object[]{KVRangeIdUtil.toString((KVRangeId)KVRangeSnapshotReceiver.this.sourceRangeId), KVRangeSnapshotReceiver.this.sourceStoreId, KVRangeSnapshotReceiver.this.sessionId});
                                onDone.complete(new IKVRangeSnapshotReceiver.Result(IKVRangeSnapshotReceiver.Code.ERROR, 0L, 0L));
                                this.dispose();
                                break;
                            }
                        }
                    }
                    catch (Throwable t) {
                        KVRangeSnapshotReceiver.this.log.error("Snapshot restored failed: session={}", (Object)KVRangeSnapshotReceiver.this.sessionId, (Object)t);
                        this.onError(t);
                        KVRangeSnapshotReceiver.this.messenger.send(KVRangeMessage.newBuilder().setRangeId(KVRangeSnapshotReceiver.this.sourceRangeId).setHostStoreId(KVRangeSnapshotReceiver.this.sourceStoreId).setSaveSnapshotDataReply(SaveSnapshotDataReply.newBuilder().setSessionId(KVRangeSnapshotReceiver.this.sessionId).setResult(SaveSnapshotDataReply.Result.Error).build()).build());
                    }
                }

                public void onError(@NonNull Throwable e) {
                    KVRangeSnapshotReceiver.this.log.error("Receiving data error: rangeId={}, storeId={}, session={}", new Object[]{KVRangeIdUtil.toString((KVRangeId)KVRangeSnapshotReceiver.this.sourceRangeId), KVRangeSnapshotReceiver.this.sourceStoreId, KVRangeSnapshotReceiver.this.sessionId, e});
                    if (e instanceof TimeoutException) {
                        onDone.complete(new IKVRangeSnapshotReceiver.Result(IKVRangeSnapshotReceiver.Code.TIME_OUT, 0L, 0L));
                    } else {
                        onDone.complete(new IKVRangeSnapshotReceiver.Result(IKVRangeSnapshotReceiver.Code.ERROR, 0L, 0L));
                    }
                    this.dispose();
                }

                public void onComplete() {
                }
            });
            onDone.whenCompleteAsync((v, e) -> {
                if (onDone.isCancelled()) {
                    observer.dispose();
                    this.messenger.send(KVRangeMessage.newBuilder().setRangeId(this.sourceRangeId).setHostStoreId(this.sourceStoreId).setSaveSnapshotDataReply(SaveSnapshotDataReply.newBuilder().setSessionId(this.sessionId).setResult(SaveSnapshotDataReply.Result.NoSessionFound).build()).build());
                }
            }, this.executor);
        }
        catch (Throwable t) {
            this.log.error("Unexpected error", t);
            onDone.completeExceptionally(t);
        }
        return CascadeCancelCompletableFuture.fromRoot(onDone);
    }
}

