/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.rocksdb;

import com.google.protobuf.Struct;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bifromq.baseenv.EnvProvider;
import org.apache.bifromq.basekv.localengine.AbstractKVSpace;
import org.apache.bifromq.basekv.localengine.IKVSpaceRefreshableReader;
import org.apache.bifromq.basekv.localengine.IKVSpaceWriter;
import org.apache.bifromq.basekv.localengine.IWALableKVSpace;
import org.apache.bifromq.basekv.localengine.KVEngineException;
import org.apache.bifromq.basekv.localengine.StructUtil;
import org.apache.bifromq.basekv.localengine.metrics.IKVSpaceMetric;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceMeters;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceOpMeters;
import org.apache.bifromq.basekv.localengine.rocksdb.IRocksDBKVSpaceEpochHandle;
import org.apache.bifromq.basekv.localengine.rocksdb.IteratorOptions;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBKVSpace;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBKVSpaceReader;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBKVSpaceWriter;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBWALableKVEngine;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBWALableKVSpaceEpochHandle;
import org.apache.bifromq.basekv.localengine.rocksdb.metrics.RocksDBKVSpaceMetric;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;

class RocksDBWALableKVSpace
extends RocksDBKVSpace
implements IWALableKVSpace {
    private final WriteOptions writeOptions;
    private final AtomicReference<CompletableFuture<Long>> flushFutureRef = new AtomicReference();
    private final ExecutorService flushExecutor;
    private final MetricManager metricMgr;
    private RocksDBWALableKVSpaceEpochHandle handle;

    RocksDBWALableKVSpace(String id, Struct conf, RocksDBWALableKVEngine engine, Runnable onDestroy, KVSpaceOpMeters opMeters, Logger logger, String ... tags) {
        super(id, conf, engine, onDestroy, opMeters, logger, tags);
        this.writeOptions = new WriteOptions().setDisableWAL(false);
        if (this.isSyncWALFlush()) {
            this.writeOptions.setSync(this.isFsyncWAL());
        }
        this.flushExecutor = ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (ExecutorService)new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), EnvProvider.INSTANCE.newThreadFactory("kvspace-flusher-" + id)), (String)"flusher", (String)"kvspace", (Iterable)Tags.of((String[])tags));
        this.metricMgr = new MetricManager(tags);
    }

    @Override
    protected void doOpen() {
        try {
            Files.createDirectories(this.spaceRootDir().getAbsoluteFile().toPath(), new FileAttribute[0]);
            this.handle = new RocksDBWALableKVSpaceEpochHandle(this.id, this.spaceRootDir(), this.conf, this.logger, this.tags);
            super.doOpen();
        }
        catch (Throwable e) {
            throw new KVEngineException("Failed to open WALable KVSpace", e);
        }
    }

    @Override
    protected RocksDBWALableKVSpaceEpochHandle handle() {
        return this.handle;
    }

    @Override
    protected void doClose() {
        CompletableFuture flushTaskFuture = Optional.ofNullable(this.flushFutureRef.get()).orElseGet(() -> {
            CompletableFuture lastOne = new CompletableFuture();
            this.flushExecutor.submit(() -> lastOne.complete(System.nanoTime()));
            return lastOne;
        });
        this.flushExecutor.shutdown();
        try {
            flushTaskFuture.join();
        }
        catch (Throwable e) {
            this.logger.debug("Flush error during closing", e);
        }
        this.writeOptions.close();
        this.metricMgr.close();
        this.handle.close();
        super.doClose();
    }

    @Override
    protected WriteOptions writeOptions() {
        return this.writeOptions;
    }

    public CompletableFuture<Long> flush() {
        if (this.state() != AbstractKVSpace.State.Opening) {
            return CompletableFuture.failedFuture((Throwable)new KVEngineException("KVSpace not open"));
        }
        if (this.isSyncWALFlush()) {
            return CompletableFuture.completedFuture(System.nanoTime());
        }
        CompletableFuture<Long> flushFuture = new CompletableFuture<Long>();
        if (this.flushFutureRef.compareAndSet(null, flushFuture)) {
            this.doFlush(flushFuture);
        } else {
            flushFuture = this.flushFutureRef.get();
            if (flushFuture == null) {
                return this.flush();
            }
        }
        return flushFuture;
    }

    public IKVSpaceWriter toWriter() {
        return new RocksDBKVSpaceWriter(this.id, (IRocksDBKVSpaceEpochHandle)this.handle, this.engine, this.writeOptions(), this.syncContext, this.writeStats.newRecorder(), this::publishMetadata, this.opMeters, this.logger);
    }

    private void doFlush(CompletableFuture<Long> onDone) {
        this.flushExecutor.submit(() -> {
            long flashStartAt = System.nanoTime();
            try {
                this.logger.trace("KVSpace[{}] flush wal start", (Object)this.id);
                try {
                    Timer.Sample start = Timer.start();
                    this.handle().db().flushWal(this.isFsyncWAL());
                    start.stop(this.metricMgr.flushTimer);
                    this.logger.trace("KVSpace[{}] flush complete", (Object)this.id);
                }
                catch (Throwable e) {
                    this.logger.error("KVSpace[{}] flush error", (Object)this.id, (Object)e);
                    throw new KVEngineException("KVSpace flush error", e);
                }
                this.flushFutureRef.compareAndSet(onDone, null);
                onDone.complete(flashStartAt);
            }
            catch (Throwable e) {
                this.flushFutureRef.compareAndSet(onDone, null);
                onDone.completeExceptionally((Throwable)new KVEngineException("KVSpace flush error", e));
            }
        });
    }

    private boolean isSyncWALFlush() {
        return !StructUtil.boolVal((Struct)this.conf, (String)"asyncWALFlush");
    }

    private boolean isFsyncWAL() {
        return StructUtil.boolVal((Struct)this.conf, (String)"fsyncWAL");
    }

    public IKVSpaceRefreshableReader reader() {
        return new RocksDBKVSpaceReader(this.id, this.opMeters, this.logger, this.syncContext.refresher(), this::handle, () -> this.currentMetadata(), new IteratorOptions(false, 524288L));
    }

    private class MetricManager {
        private final Timer flushTimer;

        MetricManager(String ... metricTags) {
            this.flushTimer = KVSpaceMeters.getTimer((String)RocksDBWALableKVSpace.this.id, (IKVSpaceMetric)RocksDBKVSpaceMetric.ManualFlushTimer, (Tags)Tags.of((String[])metricTags));
        }

        void close() {
            this.flushTimer.close();
        }
    }
}

