/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler.v3;

import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageBuilders;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import io.netty.handler.codec.mqtt.MqttUnsubAckMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.dist.client.PubResult;
import org.apache.bifromq.mqtt.handler.IMQTTProtocolHelper;
import org.apache.bifromq.mqtt.handler.RoutedMessage;
import org.apache.bifromq.mqtt.handler.TenantSettings;
import org.apache.bifromq.mqtt.handler.record.ProtocolResponse;
import org.apache.bifromq.mqtt.handler.record.SubTask;
import org.apache.bifromq.mqtt.handler.record.SubTasks;
import org.apache.bifromq.mqtt.handler.v3.MQTT3MessageBuilders;
import org.apache.bifromq.mqtt.handler.v3.MQTT3MessageUtils;
import org.apache.bifromq.mqtt.spi.IUserPropsCustomizer;
import org.apache.bifromq.plugin.authprovider.type.CheckResult;
import org.apache.bifromq.plugin.eventcollector.Event;
import org.apache.bifromq.plugin.eventcollector.OutOfTenantResource;
import org.apache.bifromq.plugin.eventcollector.ThreadLocalEventPool;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.BadPacket;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.ByServer;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.ExceedReceivingLimit;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.Idle;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.InboxTransientError;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.InvalidTopic;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.Kicked;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.MalformedTopic;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.MalformedTopicFilter;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.NoPubPermission;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.ProtocolViolation;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.Redirect;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.ResourceThrottled;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.ServerBusy;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.TooLargeSubscription;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.TooLargeUnsubscription;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.disthandling.Discard;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.disthandling.QoS1PubAcked;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.disthandling.QoS2PubReced;
import org.apache.bifromq.plugin.resourcethrottler.TenantResourceType;
import org.apache.bifromq.sysprops.props.SanityCheckMqttUtf8String;
import org.apache.bifromq.type.ClientInfo;
import org.apache.bifromq.type.Message;
import org.apache.bifromq.type.QoS;
import org.apache.bifromq.type.UserProperties;
import org.apache.bifromq.util.TopicUtil;
import org.apache.bifromq.util.UTF8Util;

public class MQTT3ProtocolHelper
implements IMQTTProtocolHelper {
    private static final boolean SANITY_CHECK = (Boolean)SanityCheckMqttUtf8String.INSTANCE.get();
    private final TenantSettings settings;
    private final ClientInfo clientInfo;
    private final IUserPropsCustomizer userPropsCustomizer;

    @Override
    public final UserProperties getUserProps(MqttPublishMessage mqttMessage) {
        return UserProperties.getDefaultInstance();
    }

    @Override
    public final UserProperties getUserProps(MqttUnsubscribeMessage mqttMessage) {
        return UserProperties.getDefaultInstance();
    }

    @Override
    public boolean checkPacketIdUsage() {
        return false;
    }

    @Override
    public ProtocolResponse onInboxTransientError(String reason) {
        return ProtocolResponse.goAway(new Event[]{((InboxTransientError)ThreadLocalEventPool.getLocal(InboxTransientError.class)).reason(reason).clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse onInboxBusy(String reason) {
        return ProtocolResponse.farewell((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_SERVER_UNAVAILABLE).build(), new Event[]{((ServerBusy)ThreadLocalEventPool.getLocal(ServerBusy.class)).reason(reason).clientInfo(this.clientInfo)});
    }

    @Override
    public Optional<Integer> sessionExpiryIntervalOnDisconnect(MqttMessage disconnectMessage) {
        return Optional.empty();
    }

    @Override
    public boolean isNormalDisconnect(MqttMessage message) {
        return true;
    }

    @Override
    public boolean isDisconnectWithLWT(MqttMessage message) {
        return false;
    }

    @Override
    public ProtocolResponse onServerShuttingDown() {
        return ProtocolResponse.goAwayNow(new Event[]{((ByServer)ThreadLocalEventPool.getLocal(ByServer.class)).clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse onResourceExhaustedDisconnect(TenantResourceType resourceType) {
        return ProtocolResponse.goAwayNow(new Event[]{((OutOfTenantResource)ThreadLocalEventPool.getLocal(OutOfTenantResource.class)).reason(resourceType.name()).clientInfo(this.clientInfo), ((ResourceThrottled)ThreadLocalEventPool.getLocal(ResourceThrottled.class)).reason(resourceType.name()).clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse respondDisconnectProtocolError() {
        return ProtocolResponse.goAway(new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("Never happen in mqtt3").clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse respondDecodeError(MqttMessage message) {
        return ProtocolResponse.goAway(new Event[]{((BadPacket)ThreadLocalEventPool.getLocal(BadPacket.class)).cause(message.decoderResult().cause()).clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse respondDuplicateConnect(MqttConnectMessage message) {
        return ProtocolResponse.goAway(new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT3-3.1.0-2").clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse validateSubMessage(MqttSubscribeMessage message) {
        List topicSubscriptions = message.payload().topicSubscriptions();
        if (topicSubscriptions.isEmpty()) {
            return ProtocolResponse.goAway(new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT3-3.8.3-3").clientInfo(this.clientInfo)});
        }
        if (topicSubscriptions.size() > this.settings.maxTopicFiltersPerSub) {
            return ProtocolResponse.goAway(new Event[]{((TooLargeSubscription)ThreadLocalEventPool.getLocal(TooLargeSubscription.class)).actual(topicSubscriptions.size()).max(this.settings.maxTopicFiltersPerSub).clientInfo(this.clientInfo)});
        }
        return null;
    }

    @Override
    public SubTasks getSubTask(MqttSubscribeMessage message) {
        List<SubTask> subTasks = message.payload().topicSubscriptions().stream().map(sub -> new SubTask(sub.topicFilter(), QoS.forNumber((int)sub.qualityOfService().value()), HLC.INST.get())).toList();
        return new SubTasks(subTasks, UserProperties.getDefaultInstance());
    }

    @Override
    public ProtocolResponse onSubBackPressured(MqttSubscribeMessage subMessage) {
        return ProtocolResponse.response((MqttMessage)MqttMessageBuilders.subAck().packetId(subMessage.variableHeader().messageId()).addGrantedQos(MqttQoS.FAILURE).build(), new Event[]{((ServerBusy)ThreadLocalEventPool.getLocal(ServerBusy.class)).reason("Too many subscribe").clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse buildSubAckMessage(MqttSubscribeMessage subMessage, List<IMQTTProtocolHelper.SubResult> results) {
        assert (subMessage.payload().topicSubscriptions().size() == results.size());
        ArrayList<MqttQoS> grantedQoSList = new ArrayList<MqttQoS>(results.size());
        block3: for (int i = 0; i < results.size(); ++i) {
            switch (results.get(i)) {
                case OK: 
                case EXISTS: {
                    grantedQoSList.add(((MqttTopicSubscription)subMessage.payload().topicSubscriptions().get(i)).qualityOfService());
                    continue block3;
                }
                default: {
                    grantedQoSList.add(MqttQoS.FAILURE);
                }
            }
        }
        return ProtocolResponse.response((MqttMessage)MqttMessageBuilders.subAck().packetId(subMessage.variableHeader().messageId()).addGrantedQoses((MqttQoS[])grantedQoSList.toArray(MqttQoS[]::new)).build(), new Event[0]);
    }

    @Override
    public MqttSubAckMessage respondPacketIdInUse(MqttSubscribeMessage message) {
        throw new UnsupportedOperationException("MQTT3 does not check packetId usage");
    }

    @Override
    public ProtocolResponse validateUnsubMessage(MqttUnsubscribeMessage message) {
        List topicFilters = message.payload().topics();
        if (topicFilters.isEmpty()) {
            return ProtocolResponse.goAway(new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT-3.10.3-2").clientInfo(this.clientInfo)});
        }
        if (topicFilters.size() > this.settings.maxTopicFiltersPerSub) {
            return ProtocolResponse.goAway(new Event[]{((TooLargeUnsubscription)ThreadLocalEventPool.getLocal(TooLargeUnsubscription.class)).max(this.settings.maxTopicFiltersPerSub).actual(topicFilters.size()).clientInfo(this.clientInfo)});
        }
        for (String topicFilter : topicFilters) {
            if (UTF8Util.isWellFormed((String)topicFilter, (boolean)SANITY_CHECK)) continue;
            return ProtocolResponse.goAway(new Event[]{((MalformedTopicFilter)ThreadLocalEventPool.getLocal(MalformedTopicFilter.class)).topicFilter(topicFilter).clientInfo(this.clientInfo)});
        }
        return null;
    }

    @Override
    public MqttUnsubAckMessage respondPacketIdInUse(MqttUnsubscribeMessage message) {
        throw new UnsupportedOperationException("MQTT3 does not check packetId usage");
    }

    @Override
    public ProtocolResponse onUnsubBackPressured(MqttUnsubscribeMessage unsubMessage) {
        return ProtocolResponse.responseNothing(new Event[]{((ServerBusy)ThreadLocalEventPool.getLocal(ServerBusy.class)).reason("Too many unsubscribe").clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse buildUnsubAckMessage(MqttUnsubscribeMessage unsubMessage, List<IMQTTProtocolHelper.UnsubResult> results) {
        return ProtocolResponse.response((MqttMessage)MqttMessageBuilders.unsubAck().packetId(unsubMessage.variableHeader().messageId()).build(), new Event[0]);
    }

    @Override
    public MqttMessage onPubRelReceived(MqttMessage message, boolean packetIdFound) {
        return MQTT3MessageBuilders.pubComp().packetId(((MqttMessageIdVariableHeader)message.variableHeader()).messageId()).build();
    }

    @Override
    public boolean isQoS2Received(MqttMessage message) {
        return true;
    }

    @Override
    public ProtocolResponse respondPubRecMsg(MqttMessage message, boolean packetIdNotFound) {
        if (packetIdNotFound) {
            return ProtocolResponse.goAway(new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT3-4.3.3-1").clientInfo(this.clientInfo)});
        }
        int packetId = ((MqttMessageIdVariableHeader)message.variableHeader()).messageId();
        return ProtocolResponse.response(MQTT3MessageBuilders.pubRel().packetId(packetId).build(), new Event[0]);
    }

    @Override
    public int clientReceiveMaximum() {
        return 65535;
    }

    @Override
    public ProtocolResponse onKick(ClientInfo killer) {
        return ProtocolResponse.goAwayNow(new Event[]{((Kicked)ThreadLocalEventPool.getLocal(Kicked.class)).kicker(killer).clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse onRedirect(boolean isPermanent, String serverReference) {
        return ProtocolResponse.goAwayNow(new Event[]{((Redirect)ThreadLocalEventPool.getLocal(Redirect.class)).isPermanent(isPermanent).serverReference(serverReference).clientInfo(this.clientInfo)});
    }

    @Override
    public MqttPublishMessage buildMqttPubMessage(int packetId, RoutedMessage message, boolean isDup) {
        return MQTT3MessageBuilders.pub().messageId(packetId).topicName(message.topic()).qos(message.qos()).retained(message.isRetain()).dup(isDup).payload(message.message().getPayload()).build();
    }

    @Override
    public ProtocolResponse respondReceivingMaximumExceeded(MqttPublishMessage message) {
        return ProtocolResponse.responseNothing(new Event[]{((ExceedReceivingLimit)ThreadLocalEventPool.getLocal(ExceedReceivingLimit.class)).limit(this.settings.receiveMaximum).clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse respondPubRateExceeded(MqttPublishMessage message) {
        return ProtocolResponse.responseNothing(new Event[]{((Discard)((Discard)((Discard)((Discard)ThreadLocalEventPool.getLocal(Discard.class)).rateLimit(this.settings.maxMsgPerSec).reqId((long)message.variableHeader().packetId())).qos(QoS.forNumber((int)message.fixedHeader().qosLevel().value())).topic(message.variableHeader().topicName())).size(message.payload().readableBytes())).clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse validatePubMessage(MqttPublishMessage message) {
        if (message.fixedHeader().isRetain() && !this.settings.retainEnabled) {
            return ProtocolResponse.goAway(new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("Retain is disabled").clientInfo(this.clientInfo)});
        }
        String topic = message.variableHeader().topicName();
        if (!UTF8Util.isWellFormed((String)topic, (boolean)SANITY_CHECK)) {
            return ProtocolResponse.goAway(new Event[]{((MalformedTopic)ThreadLocalEventPool.getLocal(MalformedTopic.class)).topic(topic).clientInfo(this.clientInfo)});
        }
        if (!TopicUtil.isValidTopic((String)topic, (int)this.settings.maxTopicLevelLength, (int)this.settings.maxTopicLevels, (int)this.settings.maxTopicLength)) {
            return ProtocolResponse.goAway(new Event[]{((InvalidTopic)ThreadLocalEventPool.getLocal(InvalidTopic.class)).topic(topic).clientInfo(this.clientInfo)});
        }
        if (message.fixedHeader().qosLevel() == MqttQoS.AT_MOST_ONCE && message.fixedHeader().isDup()) {
            return ProtocolResponse.goAway(new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT3-3.3.1-2").clientInfo(this.clientInfo)});
        }
        if (message.fixedHeader().qosLevel().value() > this.settings.maxQoS.getNumber()) {
            return ProtocolResponse.goAway(new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement(message.fixedHeader().qosLevel().value() + " is disabled").clientInfo(this.clientInfo)});
        }
        return null;
    }

    @Override
    public String getTopic(MqttPublishMessage message) {
        return message.variableHeader().topicName();
    }

    @Override
    public Message buildDistMessage(MqttPublishMessage message, ClientInfo publisher) {
        return MQTT3MessageUtils.toMessage(message, publisher, this.userPropsCustomizer);
    }

    @Override
    public ProtocolResponse onQoS0DistDenied(String topic, Message distMessage, CheckResult result) {
        return ProtocolResponse.goAway(new Event[]{((NoPubPermission)ThreadLocalEventPool.getLocal(NoPubPermission.class)).topic(topic).qos(QoS.AT_MOST_ONCE).retain(distMessage.getIsRetain()).clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse onQoS0PubHandled(PubResult result, MqttPublishMessage message, UserProperties userProps) {
        return ProtocolResponse.responseNothing(new Event[0]);
    }

    @Override
    public ProtocolResponse onQoS1DistDenied(String topic, int packetId, Message distMessage, CheckResult result) {
        return ProtocolResponse.goAway(new Event[]{((NoPubPermission)ThreadLocalEventPool.getLocal(NoPubPermission.class)).qos(QoS.AT_LEAST_ONCE).topic(topic).retain(distMessage.getIsRetain()).clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse respondQoS1PacketInUse(MqttPublishMessage message) {
        return ProtocolResponse.goAway(new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT3-2.3.1-4").clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse onQoS1PubHandled(PubResult result, MqttPublishMessage message, UserProperties userProps) {
        switch (result) {
            case OK: 
            case NO_MATCH: {
                if (this.settings.debugMode) {
                    return ProtocolResponse.response(MqttMessageBuilders.pubAck().packetId(message.variableHeader().packetId()).build(), new Event[]{((QoS1PubAcked)((QoS1PubAcked)((QoS1PubAcked)((QoS1PubAcked)ThreadLocalEventPool.getLocal(QoS1PubAcked.class)).reqId((long)message.variableHeader().packetId())).isDup(message.fixedHeader().isDup()).topic(message.variableHeader().topicName())).size(message.payload().readableBytes())).clientInfo(this.clientInfo)});
                }
                return ProtocolResponse.response(MqttMessageBuilders.pubAck().packetId(message.variableHeader().packetId()).build(), new Event[0]);
            }
        }
        return ProtocolResponse.responseNothing(new Event[0]);
    }

    @Override
    public ProtocolResponse respondQoS2PacketInUse(MqttPublishMessage message) {
        return ProtocolResponse.goAway(new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT3-2.3.1-4").clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse onQoS2DistDenied(String topic, int packetId, Message distMessage, CheckResult result) {
        return ProtocolResponse.goAway(new Event[]{((NoPubPermission)ThreadLocalEventPool.getLocal(NoPubPermission.class)).topic(topic).qos(QoS.EXACTLY_ONCE).retain(distMessage.getIsRetain()).clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse onQoS2PubHandled(PubResult result, MqttPublishMessage message, UserProperties userProps) {
        switch (result) {
            case OK: 
            case NO_MATCH: {
                if (this.settings.debugMode) {
                    return ProtocolResponse.response(MQTT3MessageBuilders.pubRec().packetId(message.variableHeader().packetId()).build(), new Event[]{((QoS2PubReced)((QoS2PubReced)((QoS2PubReced)((QoS2PubReced)ThreadLocalEventPool.getLocal(QoS2PubReced.class)).reqId((long)message.variableHeader().packetId())).isDup(message.fixedHeader().isDup()).topic(message.variableHeader().topicName())).size(message.payload().readableBytes())).clientInfo(this.clientInfo)});
                }
                return ProtocolResponse.response(MQTT3MessageBuilders.pubRec().packetId(message.variableHeader().packetId()).build(), new Event[0]);
            }
        }
        return ProtocolResponse.responseNothing(new Event[0]);
    }

    @Override
    public ProtocolResponse onIdleTimeout(int keepAliveTimeSeconds) {
        return ProtocolResponse.goAwayNow(new Event[]{((Idle)ThreadLocalEventPool.getLocal(Idle.class)).keepAliveTimeSeconds(keepAliveTimeSeconds).clientInfo(this.clientInfo)});
    }

    @Generated
    public MQTT3ProtocolHelper(TenantSettings settings, ClientInfo clientInfo, IUserPropsCustomizer userPropsCustomizer) {
        this.settings = settings;
        this.clientInfo = clientInfo;
        this.userPropsCustomizer = userPropsCustomizer;
    }
}

