/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler.v5;

import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttReasonCodeAndPropertiesVariableHeader;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.bifromq.mqtt.handler.record.ProtocolResponse;
import org.apache.bifromq.mqtt.handler.v5.IReAuthenticator;
import org.apache.bifromq.mqtt.handler.v5.MQTT5MessageBuilders;
import org.apache.bifromq.mqtt.handler.v5.MQTT5MessageUtils;
import org.apache.bifromq.mqtt.handler.v5.reason.MQTT5AuthReasonCode;
import org.apache.bifromq.mqtt.handler.v5.reason.MQTT5DisconnectReasonCode;
import org.apache.bifromq.mqtt.utils.AuthUtil;
import org.apache.bifromq.plugin.authprovider.IAuthProvider;
import org.apache.bifromq.plugin.authprovider.type.Continue;
import org.apache.bifromq.plugin.authprovider.type.MQTT5ExtendedAuthData;
import org.apache.bifromq.plugin.authprovider.type.Success;
import org.apache.bifromq.plugin.eventcollector.Event;
import org.apache.bifromq.plugin.eventcollector.ThreadLocalEventPool;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.ProtocolViolation;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.ReAuthFailed;
import org.apache.bifromq.type.ClientInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReAuthenticator
implements IReAuthenticator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReAuthenticator.class);
    private final ClientInfo clientInfo;
    private final IAuthProvider authProvider;
    private final String origAuthMethod;
    private final Executor executor;
    private final Consumer<ProtocolResponse> responder;
    private boolean isStarting;
    private boolean isAuthing;

    public ReAuthenticator(ClientInfo clientInfo, IAuthProvider authProvider, String origAuthMethod, Consumer<ProtocolResponse> responder, Executor executor) {
        this.clientInfo = clientInfo;
        this.authProvider = authProvider;
        this.origAuthMethod = origAuthMethod;
        this.executor = executor;
        this.responder = responder;
    }

    @Override
    public void onAuth(MqttMessage authMessage) {
        MqttReasonCodeAndPropertiesVariableHeader variableHeader = (MqttReasonCodeAndPropertiesVariableHeader)authMessage.variableHeader();
        MQTT5AuthReasonCode reasonCode = MQTT5AuthReasonCode.valueOf(variableHeader.reasonCode());
        switch (reasonCode) {
            case Continue: {
                if (!this.isStarting) {
                    this.responder.accept(ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.ProtocolError).reasonString("Re-auth not started").build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("Re-auth not started").clientInfo(this.clientInfo)}));
                    return;
                }
                if (this.isAuthing) {
                    this.responder.accept(ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.ProtocolError).reasonString("Unexpected auth packet during re-auth").build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("Unexpected auth packet during re-auth").clientInfo(this.clientInfo)}));
                    return;
                }
                Optional<String> authMethodOpt = MQTT5MessageUtils.authMethod(variableHeader.properties());
                if (authMethodOpt.isEmpty() || !authMethodOpt.get().equals(this.origAuthMethod)) {
                    this.responder.accept(ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.ProtocolError).reasonString("Invalid auth method: " + authMethodOpt.orElse("")).build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("Invalid auth method: " + authMethodOpt.orElse("")).clientInfo(this.clientInfo)}));
                    return;
                }
                this.authenticate(AuthUtil.buildMQTT5ExtendedAuthData(authMessage, false));
                break;
            }
            case ReAuth: {
                if (this.isStarting) {
                    this.responder.accept(ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.ProtocolError).reasonString("Re-auth in-progress").build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("Re-auth in-progress").clientInfo(this.clientInfo)}));
                    return;
                }
                if (this.isAuthing) {
                    this.responder.accept(ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.ProtocolError).reasonString("Re-auth in-progress").build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("Re-auth in-progress").clientInfo(this.clientInfo)}));
                    return;
                }
                Optional<String> authMethodOpt = MQTT5MessageUtils.authMethod(variableHeader.properties());
                if (authMethodOpt.isEmpty() || !authMethodOpt.get().equals(this.origAuthMethod)) {
                    this.responder.accept(ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.ProtocolError).reasonString("Invalid auth method: " + authMethodOpt.orElse("")).build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("Invalid auth method: " + authMethodOpt.orElse("")).clientInfo(this.clientInfo)}));
                    return;
                }
                this.isStarting = true;
                this.authenticate(AuthUtil.buildMQTT5ExtendedAuthData(authMessage, true));
                break;
            }
            default: {
                this.responder.accept(ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.ProtocolError).reasonString("Invalid reason code: " + reasonCode.value()).build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("Invalid reason code: " + reasonCode.value()).clientInfo(this.clientInfo)}));
            }
        }
    }

    private void authenticate(MQTT5ExtendedAuthData authData) {
        this.isAuthing = true;
        this.authProvider.extendedAuth(authData).thenAcceptAsync(authResult -> {
            this.isAuthing = false;
            switch (authResult.getTypeCase()) {
                case SUCCESS: {
                    this.isStarting = false;
                    Success success = authResult.getSuccess();
                    MQTT5MessageBuilders.AuthBuilder authBuilder = MQTT5MessageBuilders.auth(this.origAuthMethod).reasonCode(MQTT5AuthReasonCode.Success).userProperties(success.getUserProps());
                    if (success.hasAuthData()) {
                        authBuilder.authData(success.getAuthData());
                    }
                    this.responder.accept(ProtocolResponse.response(authBuilder.build(), new Event[0]));
                    break;
                }
                case CONTINUE: {
                    Continue authContinue = authResult.getContinue();
                    MQTT5MessageBuilders.AuthBuilder authBuilder = MQTT5MessageBuilders.auth(this.origAuthMethod).reasonCode(MQTT5AuthReasonCode.Continue).authData(authContinue.getAuthData()).userProperties(authContinue.getUserProps());
                    if (authContinue.hasReason()) {
                        authBuilder.reasonString(authContinue.getReason());
                    }
                    this.responder.accept(ProtocolResponse.response(authBuilder.build(), new Event[0]));
                    break;
                }
                default: {
                    this.responder.accept(ProtocolResponse.farewellNow(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.NotAuthorized).build(), new Event[]{((ReAuthFailed)ThreadLocalEventPool.getLocal(ReAuthFailed.class)).clientInfo(this.clientInfo)}));
                }
            }
        }, this.executor);
    }
}

