
export const root = {
    element: "definitions",
    type: "DMN15__tDefinitions" 
} as const;

export const ns = new Map<string, string>([
    ["https://www.omg.org/spec/DMN/20230324/MODEL/", ""],
    ["", "https://www.omg.org/spec/DMN/20230324/MODEL/"],
    ["https://www.omg.org/spec/DMN/20230324/DMNDI/", "dmndi:"],
    ["dmndi:", "https://www.omg.org/spec/DMN/20230324/DMNDI/"],
    ["http://www.omg.org/spec/DMN/20180521/DC/", "dc:"],
    ["dc:", "http://www.omg.org/spec/DMN/20180521/DC/"],
    ["http://www.omg.org/spec/DMN/20180521/DI/", "di:"],
    ["di:", "http://www.omg.org/spec/DMN/20180521/DI/"],
]);

export const subs = {
  "": {
    "namedElement": "DMNElement",
    "informationRequirement": "DMNElement",
    "knowledgeRequirement": "DMNElement",
    "authorityRequirement": "DMNElement",
    "functionItem": "DMNElement",
    "artifact": "DMNElement",
    "contextEntry": "DMNElement",
    "definitions": "namedElement",
    "import": "namedElement",
    "elementCollection": "namedElement",
    "drgElement": "namedElement",
    "itemDefinition": "namedElement",
    "informationItem": "namedElement",
    "decision": "drgElement",
    "invocable": "drgElement",
    "inputData": "drgElement",
    "knowledgeSource": "drgElement",
    "performanceIndicator": "businessContextElement",
    "organizationUnit": "businessContextElement",
    "businessKnowledgeModel": "invocable",
    "decisionService": "invocable",
    "literalExpression": "expression",
    "invocation": "expression",
    "decisionTable": "expression",
    "context": "expression",
    "functionDefinition": "expression",
    "relation": "expression",
    "list": "expression",
    "for": "expression",
    "every": "expression",
    "some": "expression",
    "conditional": "expression",
    "filter": "expression",
    "group": "artifact",
    "textAnnotation": "artifact",
    "association": "artifact",
  },
  "dmndi:": {
    "dmndi:DMNShape": "dmndi:DMNDiagramElement",
    "dmndi:DMNEdge": "dmndi:DMNDiagramElement",
    "dmndi:DMNStyle": "di:Style",
  },
  "dc:": {

  },
  "di:": {

  },
};

export const elements = {
  "DMNElement": "DMN15__tDMNElement",
  "namedElement": "DMN15__tNamedElement",
  "definitions": "DMN15__tDefinitions",
  "import": "DMN15__tImport",
  "elementCollection": "DMN15__tElementCollection",
  "drgElement": "DMN15__tDRGElement",
  "decision": "DMN15__tDecision",
  "businessContextElement": "DMN15__tBusinessContextElement",
  "performanceIndicator": "DMN15__tPerformanceIndicator",
  "organizationUnit": "DMN15__tOrganizationUnit",
  "invocable": "DMN15__tInvocable",
  "businessKnowledgeModel": "DMN15__tBusinessKnowledgeModel",
  "inputData": "DMN15__tInputData",
  "knowledgeSource": "DMN15__tKnowledgeSource",
  "informationRequirement": "DMN15__tInformationRequirement",
  "knowledgeRequirement": "DMN15__tKnowledgeRequirement",
  "authorityRequirement": "DMN15__tAuthorityRequirement",
  "expression": "DMN15__tExpression",
  "itemDefinition": "DMN15__tItemDefinition",
  "functionItem": "DMN15__tFunctionItem",
  "literalExpression": "DMN15__tLiteralExpression",
  "invocation": "DMN15__tInvocation",
  "informationItem": "DMN15__tInformationItem",
  "decisionTable": "DMN15__tDecisionTable",
  "artifact": "DMN15__tArtifact",
  "group": "DMN15__tGroup",
  "textAnnotation": "DMN15__tTextAnnotation",
  "association": "DMN15__tAssociation",
  "context": "DMN15__tContext",
  "contextEntry": "DMN15__tContextEntry",
  "functionDefinition": "DMN15__tFunctionDefinition",
  "relation": "DMN15__tRelation",
  "list": "DMN15__tList",
  "decisionService": "DMN15__tDecisionService",
  "for": "DMN15__tFor",
  "every": "DMN15__tQuantified",
  "some": "DMN15__tQuantified",
  "conditional": "DMN15__tConditional",
  "filter": "DMN15__tFilter",
  "dmndi:DMNDI": "DMNDI15__DMNDI",
  "dmndi:DMNDiagram": "DMNDI15__DMNDiagram",
  "dmndi:DMNDiagramElement": "DMNDI15__DiagramElement",
  "dmndi:DMNShape": "DMNDI15__DMNShape",
  "dmndi:DMNEdge": "DMNDI15__DMNEdge",
  "dmndi:DMNStyle": "DMNDI15__DMNStyle",
  "dmndi:DMNLabel": "DMNDI15__DMNLabel",
  "dmndi:DMNDecisionServiceDividerLine": "DMNDI15__DMNDecisionServiceDividerLine",
  "dc:Color": "DC__Color",
  "dc:Point": "DC__Point",
  "dc:Bounds": "DC__Bounds",
  "dc:Dimension": "DC__Dimension",
  "di:Style": "DI__Style",
};

export const meta = {
    "DMN15__tDMNElement__extensionElements": {
    },
    "DMN15__tDMNElement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tDMNElement__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonymous type..." },
    },
    "DMN15__tNamedElement__extensionElements": {
    },
    "DMN15__tNamedElement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tNamedElement__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN15__tNamedElement", xsdType: "xsd:string" },
    },
    "DMN15__tDMNElementReference": {
        "@_href": { type: "string", isArray: false, fromType: "DMN15__tDMNElementReference", xsdType: "xsd:anyURI" },
    },
    "DMN15__tDefinitions__extensionElements": {
    },
    "DMN15__tDefinitions": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tDefinitions__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN15__tNamedElement", xsdType: "xsd:string" },
        "@_expressionLanguage": { type: "string", isArray: false, fromType: "DMN15__tDefinitions", xsdType: "xsd:anyURI" },
        "@_typeLanguage": { type: "string", isArray: false, fromType: "DMN15__tDefinitions", xsdType: "xsd:anyURI" },
        "@_namespace": { type: "string", isArray: false, fromType: "DMN15__tDefinitions", xsdType: "xsd:anyURI" },
        "@_exporter": { type: "string", isArray: false, fromType: "DMN15__tDefinitions", xsdType: "xsd:string" },
        "@_exporterVersion": { type: "string", isArray: false, fromType: "DMN15__tDefinitions", xsdType: "xsd:string" },
        "import": { type: "DMN15__tImport", isArray: true, fromType: "DMN15__tDefinitions", xsdType: "// local type" },
        "itemDefinition": { type: "DMN15__tItemDefinition", isArray: true, fromType: "DMN15__tDefinitions", xsdType: "// local type" },
        "drgElement": { type: "DMN15__tDRGElement", isArray: true, fromType: "DMN15__tDefinitions", xsdType: "// local type" },
        "artifact": { type: "DMN15__tArtifact", isArray: true, fromType: "DMN15__tDefinitions", xsdType: "// local type" },
        "elementCollection": { type: "DMN15__tElementCollection", isArray: true, fromType: "DMN15__tDefinitions", xsdType: "// local type" },
        "businessContextElement": { type: "DMN15__tBusinessContextElement", isArray: true, fromType: "DMN15__tDefinitions", xsdType: "// local type" },
        "dmndi:DMNDI": { type: "DMNDI15__DMNDI", isArray: false, fromType: "DMN15__tDefinitions", xsdType: "type found from namespace with declaration name 'dmndi'." },
    },
    "DMN15__tImport__extensionElements": {
    },
    "DMN15__tImport": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tImport__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN15__tNamedElement", xsdType: "xsd:string" },
        "@_namespace": { type: "string", isArray: false, fromType: "DMN15__tImport", xsdType: "xsd:anyURI" },
        "@_locationURI": { type: "string", isArray: false, fromType: "DMN15__tImport", xsdType: "xsd:anyURI" },
        "@_importType": { type: "string", isArray: false, fromType: "DMN15__tImport", xsdType: "xsd:anyURI" },
    },
    "DMN15__tElementCollection__extensionElements": {
    },
    "DMN15__tElementCollection": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tElementCollection__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN15__tNamedElement", xsdType: "xsd:string" },
        "drgElement": { type: "DMN15__tDMNElementReference", isArray: true, fromType: "DMN15__tElementCollection", xsdType: "// local type" },
    },
    "DMN15__tDRGElement__extensionElements": {
    },
    "DMN15__tDRGElement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tDRGElement__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN15__tNamedElement", xsdType: "xsd:string" },
    },
    "DMN15__tDecision__extensionElements": {
    },
    "DMN15__tDecision": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tDecision__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN15__tNamedElement", xsdType: "xsd:string" },
        "question": { type: "string", isArray: false, fromType: "DMN15__tDecision", xsdType: "xsd:string" },
        "allowedAnswers": { type: "string", isArray: false, fromType: "DMN15__tDecision", xsdType: "xsd:string" },
        "variable": { type: "DMN15__tInformationItem", isArray: false, fromType: "DMN15__tDecision", xsdType: "// local type" },
        "informationRequirement": { type: "DMN15__tInformationRequirement", isArray: true, fromType: "DMN15__tDecision", xsdType: "// local type" },
        "knowledgeRequirement": { type: "DMN15__tKnowledgeRequirement", isArray: true, fromType: "DMN15__tDecision", xsdType: "// local type" },
        "authorityRequirement": { type: "DMN15__tAuthorityRequirement", isArray: true, fromType: "DMN15__tDecision", xsdType: "// local type" },
        "supportedObjective": { type: "DMN15__tDMNElementReference", isArray: true, fromType: "DMN15__tDecision", xsdType: "// local type" },
        "impactedPerformanceIndicator": { type: "DMN15__tDMNElementReference", isArray: true, fromType: "DMN15__tDecision", xsdType: "// local type" },
        "decisionMaker": { type: "DMN15__tDMNElementReference", isArray: true, fromType: "DMN15__tDecision", xsdType: "// local type" },
        "decisionOwner": { type: "DMN15__tDMNElementReference", isArray: true, fromType: "DMN15__tDecision", xsdType: "// local type" },
        "usingProcess": { type: "DMN15__tDMNElementReference", isArray: true, fromType: "DMN15__tDecision", xsdType: "// local type" },
        "usingTask": { type: "DMN15__tDMNElementReference", isArray: true, fromType: "DMN15__tDecision", xsdType: "// local type" },
        "expression": { type: "DMN15__tExpression", isArray: false, fromType: "DMN15__tDecision", xsdType: "// local type" },
    },
    "DMN15__tBusinessContextElement__extensionElements": {
    },
    "DMN15__tBusinessContextElement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tBusinessContextElement__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN15__tNamedElement", xsdType: "xsd:string" },
        "@_URI": { type: "string", isArray: false, fromType: "DMN15__tBusinessContextElement", xsdType: "xsd:anyURI" },
    },
    "DMN15__tPerformanceIndicator__extensionElements": {
    },
    "DMN15__tPerformanceIndicator": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tPerformanceIndicator__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN15__tNamedElement", xsdType: "xsd:string" },
        "@_URI": { type: "string", isArray: false, fromType: "DMN15__tBusinessContextElement", xsdType: "xsd:anyURI" },
        "impactingDecision": { type: "DMN15__tDMNElementReference", isArray: true, fromType: "DMN15__tPerformanceIndicator", xsdType: "// local type" },
    },
    "DMN15__tOrganizationUnit__extensionElements": {
    },
    "DMN15__tOrganizationUnit": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tOrganizationUnit__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN15__tNamedElement", xsdType: "xsd:string" },
        "@_URI": { type: "string", isArray: false, fromType: "DMN15__tBusinessContextElement", xsdType: "xsd:anyURI" },
        "decisionMade": { type: "DMN15__tDMNElementReference", isArray: true, fromType: "DMN15__tOrganizationUnit", xsdType: "// local type" },
        "decisionOwned": { type: "DMN15__tDMNElementReference", isArray: true, fromType: "DMN15__tOrganizationUnit", xsdType: "// local type" },
    },
    "DMN15__tInvocable__extensionElements": {
    },
    "DMN15__tInvocable": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tInvocable__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN15__tNamedElement", xsdType: "xsd:string" },
        "variable": { type: "DMN15__tInformationItem", isArray: false, fromType: "DMN15__tInvocable", xsdType: "// local type" },
    },
    "DMN15__tBusinessKnowledgeModel__extensionElements": {
    },
    "DMN15__tBusinessKnowledgeModel": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tBusinessKnowledgeModel__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN15__tNamedElement", xsdType: "xsd:string" },
        "variable": { type: "DMN15__tInformationItem", isArray: false, fromType: "DMN15__tInvocable", xsdType: "// local type" },
        "encapsulatedLogic": { type: "DMN15__tFunctionDefinition", isArray: false, fromType: "DMN15__tBusinessKnowledgeModel", xsdType: "// local type" },
        "knowledgeRequirement": { type: "DMN15__tKnowledgeRequirement", isArray: true, fromType: "DMN15__tBusinessKnowledgeModel", xsdType: "// local type" },
        "authorityRequirement": { type: "DMN15__tAuthorityRequirement", isArray: true, fromType: "DMN15__tBusinessKnowledgeModel", xsdType: "// local type" },
    },
    "DMN15__tInputData__extensionElements": {
    },
    "DMN15__tInputData": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tInputData__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN15__tNamedElement", xsdType: "xsd:string" },
        "variable": { type: "DMN15__tInformationItem", isArray: false, fromType: "DMN15__tInputData", xsdType: "// local type" },
    },
    "DMN15__tKnowledgeSource__extensionElements": {
    },
    "DMN15__tKnowledgeSource": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tKnowledgeSource__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN15__tNamedElement", xsdType: "xsd:string" },
        "@_locationURI": { type: "string", isArray: false, fromType: "DMN15__tKnowledgeSource", xsdType: "xsd:anyURI" },
        "authorityRequirement": { type: "DMN15__tAuthorityRequirement", isArray: true, fromType: "DMN15__tKnowledgeSource", xsdType: "// local type" },
        "type": { type: "string", isArray: false, fromType: "DMN15__tKnowledgeSource", xsdType: "xsd:string" },
        "owner": { type: "DMN15__tDMNElementReference", isArray: false, fromType: "DMN15__tKnowledgeSource", xsdType: "// local type" },
    },
    "DMN15__tInformationRequirement__extensionElements": {
    },
    "DMN15__tInformationRequirement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tInformationRequirement__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "requiredDecision": { type: "DMN15__tDMNElementReference", isArray: false, fromType: "DMN15__tInformationRequirement", xsdType: "// local type" },
        "requiredInput": { type: "DMN15__tDMNElementReference", isArray: false, fromType: "DMN15__tInformationRequirement", xsdType: "// local type" },
    },
    "DMN15__tKnowledgeRequirement__extensionElements": {
    },
    "DMN15__tKnowledgeRequirement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tKnowledgeRequirement__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "requiredKnowledge": { type: "DMN15__tDMNElementReference", isArray: false, fromType: "DMN15__tKnowledgeRequirement", xsdType: "// local type" },
    },
    "DMN15__tAuthorityRequirement__extensionElements": {
    },
    "DMN15__tAuthorityRequirement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tAuthorityRequirement__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "requiredDecision": { type: "DMN15__tDMNElementReference", isArray: false, fromType: "DMN15__tAuthorityRequirement", xsdType: "// local type" },
        "requiredInput": { type: "DMN15__tDMNElementReference", isArray: false, fromType: "DMN15__tAuthorityRequirement", xsdType: "// local type" },
        "requiredAuthority": { type: "DMN15__tDMNElementReference", isArray: false, fromType: "DMN15__tAuthorityRequirement", xsdType: "// local type" },
    },
    "DMN15__tExpression__extensionElements": {
    },
    "DMN15__tExpression": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tExpression__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN15__tExpression", xsdType: "xsd:string" },
    },
    "DMN15__tItemDefinition__extensionElements": {
    },
    "DMN15__tItemDefinition": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tItemDefinition__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN15__tNamedElement", xsdType: "xsd:string" },
        "@_typeLanguage": { type: "string", isArray: false, fromType: "DMN15__tItemDefinition", xsdType: "xsd:anyURI" },
        "@_isCollection": { type: "boolean", isArray: false, fromType: "DMN15__tItemDefinition", xsdType: "xsd:boolean" },
        "itemComponent": { type: "DMN15__tItemDefinition", isArray: true, fromType: "DMN15__tItemDefinition", xsdType: "// local type" },
        "functionItem": { type: "DMN15__tFunctionItem", isArray: false, fromType: "DMN15__tItemDefinition", xsdType: "// local type" },
        "typeRef": { type: "string", isArray: false, fromType: "DMN15__tItemDefinition", xsdType: "xsd:string" },
        "allowedValues": { type: "DMN15__tUnaryTests", isArray: false, fromType: "DMN15__tItemDefinition", xsdType: "// local type" },
        "typeConstraint": { type: "DMN15__tUnaryTests", isArray: false, fromType: "DMN15__tItemDefinition", xsdType: "// local type" },
    },
    "DMN15__tFunctionItem__extensionElements": {
    },
    "DMN15__tFunctionItem": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tFunctionItem__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_outputTypeRef": { type: "string", isArray: false, fromType: "DMN15__tFunctionItem", xsdType: "xsd:string" },
        "parameters": { type: "DMN15__tInformationItem", isArray: true, fromType: "DMN15__tFunctionItem", xsdType: "// local type" },
    },
    "DMN15__tLiteralExpression__extensionElements": {
    },
    "DMN15__tLiteralExpression": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tLiteralExpression__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN15__tExpression", xsdType: "xsd:string" },
        "@_expressionLanguage": { type: "string", isArray: false, fromType: "DMN15__tLiteralExpression", xsdType: "xsd:anyURI" },
        "text": { type: "string", isArray: false, fromType: "DMN15__tLiteralExpression", xsdType: "xsd:string" },
        "importedValues": { type: "DMN15__tImportedValues", isArray: false, fromType: "DMN15__tLiteralExpression", xsdType: "// local type" },
    },
    "DMN15__tInvocation__extensionElements": {
    },
    "DMN15__tInvocation": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tInvocation__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN15__tExpression", xsdType: "xsd:string" },
        "expression": { type: "DMN15__tExpression", isArray: false, fromType: "DMN15__tInvocation", xsdType: "// local type" },
        "binding": { type: "DMN15__tBinding", isArray: true, fromType: "DMN15__tInvocation", xsdType: "// local type" },
    },
    "DMN15__tBinding": {
        "parameter": { type: "DMN15__tInformationItem", isArray: false, fromType: "DMN15__tBinding", xsdType: "// local type" },
        "expression": { type: "DMN15__tExpression", isArray: false, fromType: "DMN15__tBinding", xsdType: "// local type" },
    },
    "DMN15__tInformationItem__extensionElements": {
    },
    "DMN15__tInformationItem": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tInformationItem__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN15__tNamedElement", xsdType: "xsd:string" },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN15__tInformationItem", xsdType: "xsd:string" },
    },
    "DMN15__tDecisionTable__extensionElements": {
    },
    "DMN15__tDecisionTable": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tDecisionTable__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN15__tExpression", xsdType: "xsd:string" },
        "@_hitPolicy": { type: "DMN15__tHitPolicy", isArray: false, fromType: "DMN15__tDecisionTable", xsdType: "// local type" },
        "@_aggregation": { type: "DMN15__tBuiltinAggregator", isArray: false, fromType: "DMN15__tDecisionTable", xsdType: "// local type" },
        "@_preferredOrientation": { type: "DMN15__tDecisionTableOrientation", isArray: false, fromType: "DMN15__tDecisionTable", xsdType: "// local type" },
        "@_outputLabel": { type: "string", isArray: false, fromType: "DMN15__tDecisionTable", xsdType: "xsd:string" },
        "input": { type: "DMN15__tInputClause", isArray: true, fromType: "DMN15__tDecisionTable", xsdType: "// local type" },
        "output": { type: "DMN15__tOutputClause", isArray: true, fromType: "DMN15__tDecisionTable", xsdType: "// local type" },
        "annotation": { type: "DMN15__tRuleAnnotationClause", isArray: true, fromType: "DMN15__tDecisionTable", xsdType: "// local type" },
        "rule": { type: "DMN15__tDecisionRule", isArray: true, fromType: "DMN15__tDecisionTable", xsdType: "// local type" },
    },
    "DMN15__tInputClause__extensionElements": {
    },
    "DMN15__tInputClause": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tInputClause__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "inputExpression": { type: "DMN15__tLiteralExpression", isArray: false, fromType: "DMN15__tInputClause", xsdType: "// local type" },
        "inputValues": { type: "DMN15__tUnaryTests", isArray: false, fromType: "DMN15__tInputClause", xsdType: "// local type" },
    },
    "DMN15__tOutputClause__extensionElements": {
    },
    "DMN15__tOutputClause": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tOutputClause__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN15__tOutputClause", xsdType: "xsd:string" },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN15__tOutputClause", xsdType: "xsd:string" },
        "outputValues": { type: "DMN15__tUnaryTests", isArray: false, fromType: "DMN15__tOutputClause", xsdType: "// local type" },
        "defaultOutputEntry": { type: "DMN15__tLiteralExpression", isArray: false, fromType: "DMN15__tOutputClause", xsdType: "// local type" },
    },
    "DMN15__tRuleAnnotationClause": {
        "@_name": { type: "string", isArray: false, fromType: "DMN15__tRuleAnnotationClause", xsdType: "xsd:string" },
    },
    "DMN15__tDecisionRule__extensionElements": {
    },
    "DMN15__tDecisionRule": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tDecisionRule__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "inputEntry": { type: "DMN15__tUnaryTests", isArray: true, fromType: "DMN15__tDecisionRule", xsdType: "// local type" },
        "outputEntry": { type: "DMN15__tLiteralExpression", isArray: true, fromType: "DMN15__tDecisionRule", xsdType: "// local type" },
        "annotationEntry": { type: "DMN15__tRuleAnnotation", isArray: true, fromType: "DMN15__tDecisionRule", xsdType: "// local type" },
    },
    "DMN15__tRuleAnnotation": {
        "text": { type: "string", isArray: false, fromType: "DMN15__tRuleAnnotation", xsdType: "xsd:string" },
    },
    "DMN15__tImportedValues__extensionElements": {
    },
    "DMN15__tImportedValues": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tImportedValues__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN15__tNamedElement", xsdType: "xsd:string" },
        "@_namespace": { type: "string", isArray: false, fromType: "DMN15__tImport", xsdType: "xsd:anyURI" },
        "@_locationURI": { type: "string", isArray: false, fromType: "DMN15__tImport", xsdType: "xsd:anyURI" },
        "@_importType": { type: "string", isArray: false, fromType: "DMN15__tImport", xsdType: "xsd:anyURI" },
        "@_expressionLanguage": { type: "string", isArray: false, fromType: "DMN15__tImportedValues", xsdType: "xsd:anyURI" },
        "importedElement": { type: "string", isArray: false, fromType: "DMN15__tImportedValues", xsdType: "xsd:string" },
    },
    "DMN15__tArtifact__extensionElements": {
    },
    "DMN15__tArtifact": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tArtifact__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
    },
    "DMN15__tGroup__extensionElements": {
    },
    "DMN15__tGroup": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tGroup__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN15__tGroup", xsdType: "xsd:string" },
    },
    "DMN15__tTextAnnotation__extensionElements": {
    },
    "DMN15__tTextAnnotation": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tTextAnnotation__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_textFormat": { type: "string", isArray: false, fromType: "DMN15__tTextAnnotation", xsdType: "xsd:string" },
        "text": { type: "string", isArray: false, fromType: "DMN15__tTextAnnotation", xsdType: "xsd:string" },
    },
    "DMN15__tAssociation__extensionElements": {
    },
    "DMN15__tAssociation": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tAssociation__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_associationDirection": { type: "DMN15__tAssociationDirection", isArray: false, fromType: "DMN15__tAssociation", xsdType: "// local type" },
        "sourceRef": { type: "DMN15__tDMNElementReference", isArray: false, fromType: "DMN15__tAssociation", xsdType: "// local type" },
        "targetRef": { type: "DMN15__tDMNElementReference", isArray: false, fromType: "DMN15__tAssociation", xsdType: "// local type" },
    },
    "DMN15__tContext__extensionElements": {
    },
    "DMN15__tContext": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tContext__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN15__tExpression", xsdType: "xsd:string" },
        "contextEntry": { type: "DMN15__tContextEntry", isArray: true, fromType: "DMN15__tContext", xsdType: "// local type" },
    },
    "DMN15__tContextEntry__extensionElements": {
    },
    "DMN15__tContextEntry": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tContextEntry__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "variable": { type: "DMN15__tInformationItem", isArray: false, fromType: "DMN15__tContextEntry", xsdType: "// local type" },
        "expression": { type: "DMN15__tExpression", isArray: false, fromType: "DMN15__tContextEntry", xsdType: "// local type" },
    },
    "DMN15__tFunctionDefinition__extensionElements": {
    },
    "DMN15__tFunctionDefinition": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tFunctionDefinition__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN15__tExpression", xsdType: "xsd:string" },
        "@_kind": { type: "DMN15__tFunctionKind", isArray: false, fromType: "DMN15__tFunctionDefinition", xsdType: "// local type" },
        "formalParameter": { type: "DMN15__tInformationItem", isArray: true, fromType: "DMN15__tFunctionDefinition", xsdType: "// local type" },
        "expression": { type: "DMN15__tExpression", isArray: false, fromType: "DMN15__tFunctionDefinition", xsdType: "// local type" },
    },
    "DMN15__tRelation__extensionElements": {
    },
    "DMN15__tRelation": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tRelation__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN15__tExpression", xsdType: "xsd:string" },
        "column": { type: "DMN15__tInformationItem", isArray: true, fromType: "DMN15__tRelation", xsdType: "// local type" },
        "row": { type: "DMN15__tList", isArray: true, fromType: "DMN15__tRelation", xsdType: "// local type" },
    },
    "DMN15__tList__extensionElements": {
    },
    "DMN15__tList": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tList__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN15__tExpression", xsdType: "xsd:string" },
        "expression": { type: "DMN15__tExpression", isArray: true, fromType: "DMN15__tList", xsdType: "// local type" },
    },
    "DMN15__tUnaryTests__extensionElements": {
    },
    "DMN15__tUnaryTests": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tUnaryTests__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN15__tExpression", xsdType: "xsd:string" },
        "@_expressionLanguage": { type: "string", isArray: false, fromType: "DMN15__tUnaryTests", xsdType: "xsd:anyURI" },
        "text": { type: "string", isArray: false, fromType: "DMN15__tUnaryTests", xsdType: "xsd:string" },
    },
    "DMN15__tDecisionService__extensionElements": {
    },
    "DMN15__tDecisionService": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tDecisionService__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN15__tNamedElement", xsdType: "xsd:string" },
        "variable": { type: "DMN15__tInformationItem", isArray: false, fromType: "DMN15__tInvocable", xsdType: "// local type" },
        "outputDecision": { type: "DMN15__tDMNElementReference", isArray: true, fromType: "DMN15__tDecisionService", xsdType: "// local type" },
        "encapsulatedDecision": { type: "DMN15__tDMNElementReference", isArray: true, fromType: "DMN15__tDecisionService", xsdType: "// local type" },
        "inputDecision": { type: "DMN15__tDMNElementReference", isArray: true, fromType: "DMN15__tDecisionService", xsdType: "// local type" },
        "inputData": { type: "DMN15__tDMNElementReference", isArray: true, fromType: "DMN15__tDecisionService", xsdType: "// local type" },
    },
    "DMN15__tChildExpression": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tChildExpression", xsdType: "xsd:ID" },
        "expression": { type: "DMN15__tExpression", isArray: false, fromType: "DMN15__tChildExpression", xsdType: "// local type" },
    },
    "DMN15__tTypedChildExpression": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tChildExpression", xsdType: "xsd:ID" },
        "expression": { type: "DMN15__tExpression", isArray: false, fromType: "DMN15__tChildExpression", xsdType: "// local type" },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN15__tTypedChildExpression", xsdType: "xsd:string" },
    },
    "DMN15__tIterator__extensionElements": {
    },
    "DMN15__tIterator": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tIterator__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN15__tExpression", xsdType: "xsd:string" },
        "@_iteratorVariable": { type: "string", isArray: false, fromType: "DMN15__tIterator", xsdType: "xsd:string" },
        "in": { type: "DMN15__tTypedChildExpression", isArray: false, fromType: "DMN15__tIterator", xsdType: "// local type" },
    },
    "DMN15__tFor__extensionElements": {
    },
    "DMN15__tFor": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tFor__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN15__tExpression", xsdType: "xsd:string" },
        "@_iteratorVariable": { type: "string", isArray: false, fromType: "DMN15__tIterator", xsdType: "xsd:string" },
        "in": { type: "DMN15__tTypedChildExpression", isArray: false, fromType: "DMN15__tIterator", xsdType: "// local type" },
        "return": { type: "DMN15__tChildExpression", isArray: false, fromType: "DMN15__tFor", xsdType: "// local type" },
    },
    "DMN15__tQuantified__extensionElements": {
    },
    "DMN15__tQuantified": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tQuantified__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN15__tExpression", xsdType: "xsd:string" },
        "@_iteratorVariable": { type: "string", isArray: false, fromType: "DMN15__tIterator", xsdType: "xsd:string" },
        "in": { type: "DMN15__tTypedChildExpression", isArray: false, fromType: "DMN15__tIterator", xsdType: "// local type" },
        "satisfies": { type: "DMN15__tChildExpression", isArray: false, fromType: "DMN15__tQuantified", xsdType: "// local type" },
    },
    "DMN15__tConditional__extensionElements": {
    },
    "DMN15__tConditional": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tConditional__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN15__tExpression", xsdType: "xsd:string" },
        "if": { type: "DMN15__tChildExpression", isArray: false, fromType: "DMN15__tConditional", xsdType: "// local type" },
        "then": { type: "DMN15__tChildExpression", isArray: false, fromType: "DMN15__tConditional", xsdType: "// local type" },
        "else": { type: "DMN15__tChildExpression", isArray: false, fromType: "DMN15__tConditional", xsdType: "// local type" },
    },
    "DMN15__tFilter__extensionElements": {
    },
    "DMN15__tFilter": {
        "@_id": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN15__tFilter__extensionElements", isArray: false, fromType: "DMN15__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN15__tExpression", xsdType: "xsd:string" },
        "in": { type: "DMN15__tChildExpression", isArray: false, fromType: "DMN15__tFilter", xsdType: "// local type" },
        "match": { type: "DMN15__tChildExpression", isArray: false, fromType: "DMN15__tFilter", xsdType: "// local type" },
    },
    "DMNDI15__DMNDI": {
        "dmndi:DMNDiagram": { type: "DMNDI15__DMNDiagram", isArray: true, fromType: "DMNDI15__DMNDI", xsdType: "type found from namespace with declaration name 'dmndi'." },
        "dmndi:DMNStyle": { type: "DMNDI15__DMNStyle", isArray: true, fromType: "DMNDI15__DMNDI", xsdType: "type found from namespace with declaration name 'dmndi'." },
    },
    "DMNDI15__DMNDiagram__extension": {
    },
    "DMNDI15__DMNDiagram": {
        "@_sharedStyle": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:IDREF" },
        "@_id": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:ID" },
        "di:extension": { type: "DMNDI15__DMNDiagram__extension", isArray: false, fromType: "DI__DiagramElement", xsdType: "Anonumous type..." },
        "di:Style": { type: "DI__Style", isArray: false, fromType: "DI__DiagramElement", xsdType: "type found from namespace with declaration name 'di'." },
        "@_name": { type: "string", isArray: false, fromType: "DI__Diagram", xsdType: "xsd:string" },
        "@_documentation": { type: "string", isArray: false, fromType: "DI__Diagram", xsdType: "xsd:string" },
        "@_resolution": { type: "float", isArray: false, fromType: "DI__Diagram", xsdType: "xsd:double" },
        "@_useAlternativeInputDataShape": { type: "boolean", isArray: false, fromType: "DMNDI15__DMNDiagram", xsdType: "xsd:boolean" },
        "dmndi:Size": { type: "DC__Dimension", isArray: false, fromType: "DMNDI15__DMNDiagram", xsdType: "type found from namespace with declaration name 'dc'." },
        "dmndi:DMNDiagramElement": { type: "DI__DiagramElement", isArray: true, fromType: "DMNDI15__DMNDiagram", xsdType: "type found from namespace with declaration name 'di'." },
    },
    "DMNDI15__DMNShape__extension": {
    },
    "DMNDI15__DMNShape": {
        "@_sharedStyle": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:IDREF" },
        "@_id": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:ID" },
        "di:extension": { type: "DMNDI15__DMNShape__extension", isArray: false, fromType: "DI__DiagramElement", xsdType: "Anonumous type..." },
        "di:Style": { type: "DI__Style", isArray: false, fromType: "DI__DiagramElement", xsdType: "type found from namespace with declaration name 'di'." },
        "dc:Bounds": { type: "DC__Bounds", isArray: false, fromType: "DI__Shape", xsdType: "type found from namespace with declaration name 'dc'." },
        "@_dmnElementRef": { type: "string", isArray: false, fromType: "DMNDI15__DMNShape", xsdType: "xsd:QName" },
        "@_isListedInputData": { type: "boolean", isArray: false, fromType: "DMNDI15__DMNShape", xsdType: "xsd:boolean" },
        "@_isCollapsed": { type: "boolean", isArray: false, fromType: "DMNDI15__DMNShape", xsdType: "xsd:boolean" },
        "dmndi:DMNLabel": { type: "DMNDI15__DMNLabel", isArray: false, fromType: "DMNDI15__DMNShape", xsdType: "type found from namespace with declaration name 'dmndi'." },
        "dmndi:DMNDecisionServiceDividerLine": { type: "DMNDI15__DMNDecisionServiceDividerLine", isArray: false, fromType: "DMNDI15__DMNShape", xsdType: "type found from namespace with declaration name 'dmndi'." },
    },
    "DMNDI15__DMNDecisionServiceDividerLine__extension": {
    },
    "DMNDI15__DMNDecisionServiceDividerLine": {
        "@_sharedStyle": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:IDREF" },
        "@_id": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:ID" },
        "di:extension": { type: "DMNDI15__DMNDecisionServiceDividerLine__extension", isArray: false, fromType: "DI__DiagramElement", xsdType: "Anonumous type..." },
        "di:Style": { type: "DI__Style", isArray: false, fromType: "DI__DiagramElement", xsdType: "type found from namespace with declaration name 'di'." },
        "di:waypoint": { type: "DC__Point", isArray: true, fromType: "DI__Edge", xsdType: "type found from namespace with declaration name 'dc'." },
    },
    "DMNDI15__DMNEdge__extension": {
    },
    "DMNDI15__DMNEdge": {
        "@_sharedStyle": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:IDREF" },
        "@_id": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:ID" },
        "di:extension": { type: "DMNDI15__DMNEdge__extension", isArray: false, fromType: "DI__DiagramElement", xsdType: "Anonumous type..." },
        "di:Style": { type: "DI__Style", isArray: false, fromType: "DI__DiagramElement", xsdType: "type found from namespace with declaration name 'di'." },
        "di:waypoint": { type: "DC__Point", isArray: true, fromType: "DI__Edge", xsdType: "type found from namespace with declaration name 'dc'." },
        "@_dmnElementRef": { type: "string", isArray: false, fromType: "DMNDI15__DMNEdge", xsdType: "xsd:QName" },
        "@_sourceElement": { type: "string", isArray: false, fromType: "DMNDI15__DMNEdge", xsdType: "xsd:QName" },
        "@_targetElement": { type: "string", isArray: false, fromType: "DMNDI15__DMNEdge", xsdType: "xsd:QName" },
        "dmndi:DMNLabel": { type: "DMNDI15__DMNLabel", isArray: false, fromType: "DMNDI15__DMNEdge", xsdType: "type found from namespace with declaration name 'dmndi'." },
    },
    "DMNDI15__DMNLabel__extension": {
    },
    "DMNDI15__DMNLabel": {
        "@_sharedStyle": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:IDREF" },
        "@_id": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:ID" },
        "di:extension": { type: "DMNDI15__DMNLabel__extension", isArray: false, fromType: "DI__DiagramElement", xsdType: "Anonumous type..." },
        "di:Style": { type: "DI__Style", isArray: false, fromType: "DI__DiagramElement", xsdType: "type found from namespace with declaration name 'di'." },
        "dc:Bounds": { type: "DC__Bounds", isArray: false, fromType: "DI__Shape", xsdType: "type found from namespace with declaration name 'dc'." },
        "dmndi:Text": { type: "string", isArray: false, fromType: "DMNDI15__DMNLabel", xsdType: "xsd:string" },
    },
    "DMNDI15__DMNStyle__extension": {
    },
    "DMNDI15__DMNStyle": {
        "@_id": { type: "string", isArray: false, fromType: "DI__Style", xsdType: "xsd:ID" },
        "di:extension": { type: "DMNDI15__DMNStyle__extension", isArray: false, fromType: "DI__Style", xsdType: "Anonumous type..." },
        "@_fontFamily": { type: "string", isArray: false, fromType: "DMNDI15__DMNStyle", xsdType: "xsd:string" },
        "@_fontSize": { type: "float", isArray: false, fromType: "DMNDI15__DMNStyle", xsdType: "xsd:double" },
        "@_fontItalic": { type: "boolean", isArray: false, fromType: "DMNDI15__DMNStyle", xsdType: "xsd:boolean" },
        "@_fontBold": { type: "boolean", isArray: false, fromType: "DMNDI15__DMNStyle", xsdType: "xsd:boolean" },
        "@_fontUnderline": { type: "boolean", isArray: false, fromType: "DMNDI15__DMNStyle", xsdType: "xsd:boolean" },
        "@_fontStrikeThrough": { type: "boolean", isArray: false, fromType: "DMNDI15__DMNStyle", xsdType: "xsd:boolean" },
        "@_labelHorizontalAlignement": { type: "DC__AlignmentKind", isArray: false, fromType: "DMNDI15__DMNStyle", xsdType: "type found from namespace with declaration name 'dc'." },
        "@_labelVerticalAlignment": { type: "DC__AlignmentKind", isArray: false, fromType: "DMNDI15__DMNStyle", xsdType: "type found from namespace with declaration name 'dc'." },
        "dmndi:FillColor": { type: "DC__Color", isArray: false, fromType: "DMNDI15__DMNStyle", xsdType: "type found from namespace with declaration name 'dc'." },
        "dmndi:StrokeColor": { type: "DC__Color", isArray: false, fromType: "DMNDI15__DMNStyle", xsdType: "type found from namespace with declaration name 'dc'." },
        "dmndi:FontColor": { type: "DC__Color", isArray: false, fromType: "DMNDI15__DMNStyle", xsdType: "type found from namespace with declaration name 'dc'." },
    },
    "DC__Color": {
        "@_red": { type: "integer", isArray: false, fromType: "DC__Color", xsdType: "xsd:int" },
        "@_green": { type: "integer", isArray: false, fromType: "DC__Color", xsdType: "xsd:int" },
        "@_blue": { type: "integer", isArray: false, fromType: "DC__Color", xsdType: "xsd:int" },
    },
    "DC__Point": {
        "@_x": { type: "float", isArray: false, fromType: "DC__Point", xsdType: "xsd:double" },
        "@_y": { type: "float", isArray: false, fromType: "DC__Point", xsdType: "xsd:double" },
    },
    "DC__Dimension": {
        "@_width": { type: "float", isArray: false, fromType: "DC__Dimension", xsdType: "xsd:double" },
        "@_height": { type: "float", isArray: false, fromType: "DC__Dimension", xsdType: "xsd:double" },
    },
    "DC__Bounds": {
        "@_x": { type: "float", isArray: false, fromType: "DC__Bounds", xsdType: "xsd:double" },
        "@_y": { type: "float", isArray: false, fromType: "DC__Bounds", xsdType: "xsd:double" },
        "@_width": { type: "float", isArray: false, fromType: "DC__Bounds", xsdType: "xsd:double" },
        "@_height": { type: "float", isArray: false, fromType: "DC__Bounds", xsdType: "xsd:double" },
    },
    "DI__DiagramElement__extension": {
    },
    "DI__Diagram__extension": {
    },
    "DI__Shape__extension": {
    },
    "DI__Edge__extension": {
    },
    "DI__Style__extension": {
    },
} as const;
