import React, { useEffect, useState } from "react";
import { ToolbarFilter, ToolbarGroup, ToolbarItem, ToolbarToggleGroup, Toolbar, ToolbarContent, } from "@patternfly/react-core/dist/js/components/Toolbar";
import { Select, SelectOption, SelectVariant, } from "@patternfly/react-core/dist/js/components/Select";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { InputGroup } from "@patternfly/react-core/dist/js/components/InputGroup";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { FilterIcon } from "@patternfly/react-icons/dist/js/icons/filter-icon";
import { SyncIcon } from "@patternfly/react-icons/dist/js/icons/sync-icon";
import _ from "lodash";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools/OuiaUtils";
var Category;
(function (Category) {
    Category["STATUS"] = "Status";
    Category["TASK_NAME"] = "Task name";
})(Category || (Category = {}));
const TaskInboxToolbar = ({ activeFilter, allTaskStates, activeTaskStates, applyFilter, refresh, ouiaSafe, ouiaId, }) => {
    const [isStatusExpanded, setStatusExpanded] = useState(false);
    const [allStates, setAllStates] = useState([]);
    const [activeStates, setActiveStates] = useState([]);
    const [filterTaskStates, setFilterTaskStates] = useState([]);
    const [filterTaskNames, setFilterTaskNames] = useState([]);
    const [selectedTaskStates, setSelectedTaskStates] = useState([]);
    const [taskNameInput, setTaskNameInput] = useState("");
    useEffect(() => {
        setAllStates(allTaskStates);
        setActiveStates(activeTaskStates);
        setSelectedTaskStates(activeFilter.taskStates);
        setFilterTaskStates(activeFilter.taskStates);
        setFilterTaskNames(activeFilter.taskNames);
    }, [activeFilter]);
    const createStatusMenuItems = () => {
        return allStates.map((state) => React.createElement(SelectOption, { key: state, value: state }));
    };
    const doResetFilter = () => {
        applyFilter({
            taskStates: activeStates,
            taskNames: [],
        });
    };
    const onDeleteFilterGroup = (categoryName, value) => {
        const newFilterTaskStates = [...filterTaskStates];
        const newFilterTaskNames = [...filterTaskNames];
        switch (categoryName) {
            case Category.STATUS:
                _.remove(newFilterTaskStates, (status) => {
                    return status === value;
                });
                setFilterTaskStates(newFilterTaskStates);
                setSelectedTaskStates(newFilterTaskStates);
                break;
            case Category.TASK_NAME:
                _.remove(newFilterTaskNames, (status) => {
                    return status === value;
                });
                setFilterTaskNames(newFilterTaskNames);
                break;
        }
        applyFilter({
            taskNames: newFilterTaskNames,
            taskStates: newFilterTaskStates,
        });
    };
    const onSelectTaskState = (event, selection) => {
        const filter = [...selectedTaskStates];
        if (!filter.includes(selection.toString())) {
            filter.push(selection.toString());
        }
        else {
            _.remove(filter, (status) => {
                return status === selection;
            });
        }
        setSelectedTaskStates(filter);
    };
    const doApplyFilter = () => {
        const newTaskNames = [...filterTaskNames];
        if (taskNameInput && !newTaskNames.includes(taskNameInput)) {
            newTaskNames.push(taskNameInput);
            setFilterTaskNames(newTaskNames);
        }
        setFilterTaskStates([...selectedTaskStates]);
        setTaskNameInput("");
        applyFilter({
            taskStates: [...selectedTaskStates],
            taskNames: newTaskNames,
        });
    };
    const toggleGroupItems = (React.createElement(React.Fragment, null,
        React.createElement(ToolbarGroup, { variant: "filter-group" },
            React.createElement(ToolbarFilter, { chips: filterTaskStates, deleteChip: onDeleteFilterGroup, categoryName: Category.STATUS },
                React.createElement(Select, { variant: SelectVariant.checkbox, "aria-label": "Status", onToggle: setStatusExpanded, onSelect: onSelectTaskState, selections: selectedTaskStates, isOpen: isStatusExpanded, placeholderText: "Status" }, createStatusMenuItems())),
            React.createElement(ToolbarFilter, { chips: filterTaskNames, deleteChip: onDeleteFilterGroup, categoryName: Category.TASK_NAME },
                React.createElement(InputGroup, null,
                    React.createElement(TextInput, { name: "taskName", id: "taskName", type: "search", "aria-label": "task name", onChange: setTaskNameInput, placeholder: "Filter by Task name", value: taskNameInput }))),
            React.createElement(ToolbarItem, null,
                React.createElement(Button, { id: "apply-filter", variant: "primary", onClick: doApplyFilter, isDisabled: _.isEmpty(selectedTaskStates) && _.isEmpty(taskNameInput) }, "Apply Filter")))));
    const toolbarItems = (React.createElement(React.Fragment, null,
        React.createElement(ToolbarToggleGroup, { toggleIcon: React.createElement(FilterIcon, null), breakpoint: "xl" }, toggleGroupItems),
        React.createElement(ToolbarGroup, { variant: "icon-button-group" },
            React.createElement(ToolbarItem, null,
                React.createElement(Tooltip, { content: "Refresh" },
                    React.createElement(Button, { variant: "plain", onClick: refresh, id: "refresh" },
                        React.createElement(SyncIcon, null)))))));
    return (React.createElement(Toolbar, Object.assign({ id: "task-inbox-with-filter", className: "pf-m-toggle-group-container", collapseListedFiltersBreakpoint: "xl", clearAllFilters: doResetFilter, clearFiltersButtonText: "Reset to default" }, componentOuiaProps(ouiaId, "task-inbox-toolbar", ouiaSafe)),
        React.createElement(ToolbarContent, null, toolbarItems)));
};
export default TaskInboxToolbar;
//# sourceMappingURL=TaskInboxToolbar.js.map