import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback, useEffect, useMemo, useRef } from "react";
import { BeeTableHeaderVisibility, BeeTableOperation, DmnBuiltInDataType, } from "../../api";
import { useNestedExpressionContainer } from "../../resizing/NestedExpressionContainerContext";
import { LITERAL_EXPRESSION_EXTRA_WIDTH, LITERAL_EXPRESSION_MIN_WIDTH, LITERAL_EXPRESSION_WIDTH_INDEX, } from "../../resizing/WidthConstants";
import { BeeTable } from "../../table/BeeTable";
import { usePublishedBeeTableResizableColumns } from "../../resizing/BeeTableResizableColumnsContext";
import { useBeeTableCoordinates, useBeeTableSelectableCellRef } from "../../selection/BeeTableSelectionContext";
import { useBoxedExpressionEditor, useBoxedExpressionEditorDispatch } from "../../BoxedExpressionEditorContext";
import { DEFAULT_EXPRESSION_VARIABLE_NAME } from "../../expressionVariable/ExpressionVariableMenu";
import { ResizerStopBehavior } from "../../resizing/ResizingWidthsContext";
import { useBoxedExpressionEditorI18n } from "../../i18n";
import "./LiteralExpression.css";
export function LiteralExpression({ isNested, expression: literalExpression, }) {
    var _a, _b;
    const { setExpression, setWidthsById } = useBoxedExpressionEditorDispatch();
    const { expressionHolderId, widthsById } = useBoxedExpressionEditor();
    const id = literalExpression["@_id"];
    const getValue = useCallback(() => {
        var _a, _b;
        return (_b = (_a = literalExpression.text) === null || _a === void 0 ? void 0 : _a.__$$text) !== null && _b !== void 0 ? _b : "";
    }, [literalExpression.text]);
    const setValue = useCallback((value) => {
        setExpression((prev) => {
            const ret = Object.assign(Object.assign({}, literalExpression), { text: { __$$text: value } });
            return ret;
        });
    }, [literalExpression, setExpression]);
    const width = useMemo(() => {
        var _a, _b;
        return (_b = (_a = widthsById.get(id)) === null || _a === void 0 ? void 0 : _a[LITERAL_EXPRESSION_WIDTH_INDEX]) !== null && _b !== void 0 ? _b : LITERAL_EXPRESSION_MIN_WIDTH;
    }, [id, widthsById]);
    const { containerCellCoordinates } = useBeeTableCoordinates();
    useBeeTableSelectableCellRef((_a = containerCellCoordinates === null || containerCellCoordinates === void 0 ? void 0 : containerCellCoordinates.rowIndex) !== null && _a !== void 0 ? _a : 0, (_b = containerCellCoordinates === null || containerCellCoordinates === void 0 ? void 0 : containerCellCoordinates.columnIndex) !== null && _b !== void 0 ? _b : 0, setValue, getValue);
    const onColumnUpdates = useCallback(([{ name, typeRef }]) => {
        setExpression(() => (Object.assign(Object.assign({}, literalExpression), { "@_label": name, "@_typeRef": typeRef })));
    }, [literalExpression, setExpression]);
    const setLiteralExpressionWidth = useCallback((newWidthAction) => {
        setWidthsById(({ newMap }) => {
            var _a;
            const prev = (_a = newMap.get(id)) !== null && _a !== void 0 ? _a : [];
            const prevWidth = prev[LITERAL_EXPRESSION_WIDTH_INDEX];
            const newWidth = typeof newWidthAction === "function" ? newWidthAction(prevWidth) : newWidthAction;
            newMap.set(id, [newWidth !== null && newWidth !== void 0 ? newWidth : LITERAL_EXPRESSION_MIN_WIDTH]);
        });
    }, [id, setWidthsById]);
    const onCellUpdates = useCallback((cellUpdates) => {
        setValue(cellUpdates[0].value);
    }, [setValue]);
    const { onColumnResizingWidthChange, isPivoting } = usePublishedBeeTableResizableColumns(id, 1, false);
    const nestedExpressionContainer = useNestedExpressionContainer();
    const minWidth = useMemo(() => {
        return Math.max(nestedExpressionContainer.minWidth - LITERAL_EXPRESSION_EXTRA_WIDTH, LITERAL_EXPRESSION_MIN_WIDTH);
    }, [nestedExpressionContainer]);
    const beeTableRef = useRef(null);
    useEffect(() => {
        var _a;
        if (isPivoting || !isNested) {
            return;
        }
        const COLUMN_INDEX = 1;
        (_a = beeTableRef.current) === null || _a === void 0 ? void 0 : _a.updateColumnResizingWidths(new Map([
            [
                COLUMN_INDEX,
                {
                    value: Math.max(nestedExpressionContainer.resizingWidth.value - LITERAL_EXPRESSION_EXTRA_WIDTH, minWidth),
                    isPivoting: false,
                },
            ],
        ]));
    }, [isPivoting, isNested, minWidth, nestedExpressionContainer.resizingWidth.value]);
    const beeTableColumns = useMemo(() => {
        var _a, _b;
        return [
            {
                accessor: expressionHolderId,
                label: (_a = literalExpression["@_label"]) !== null && _a !== void 0 ? _a : DEFAULT_EXPRESSION_VARIABLE_NAME,
                isRowIndexColumn: false,
                dataType: (_b = literalExpression["@_typeRef"]) !== null && _b !== void 0 ? _b : DmnBuiltInDataType.Undefined,
                minWidth,
                width,
                setWidth: setLiteralExpressionWidth,
            },
        ];
    }, [expressionHolderId, literalExpression, minWidth, setLiteralExpressionWidth, width]);
    const beeTableRows = useMemo(() => {
        var _a, _b;
        return [{ [expressionHolderId]: { content: (_b = (_a = literalExpression.text) === null || _a === void 0 ? void 0 : _a.__$$text) !== null && _b !== void 0 ? _b : "", id } }];
    }, [expressionHolderId, literalExpression.text, id]);
    const beeTableHeaderVisibility = useMemo(() => {
        return isNested ? BeeTableHeaderVisibility.None : BeeTableHeaderVisibility.AllLevels;
    }, [isNested]);
    const getRowKey = useCallback((row) => {
        return row.id;
    }, []);
    const { i18n } = useBoxedExpressionEditorI18n();
    const beeTableOperationConfig = useMemo(() => {
        return [
            {
                group: i18n.terms.selection.toUpperCase(),
                items: [
                    { name: i18n.terms.copy, type: BeeTableOperation.SelectionCopy },
                    { name: i18n.terms.cut, type: BeeTableOperation.SelectionCut },
                    { name: i18n.terms.paste, type: BeeTableOperation.SelectionPaste },
                    { name: i18n.terms.reset, type: BeeTableOperation.SelectionReset },
                ],
            },
        ];
    }, [i18n]);
    const allowedOperations = useCallback((conditions) => {
        if (!conditions.selection.selectionStart || !conditions.selection.selectionEnd) {
            return [];
        }
        return [
            BeeTableOperation.SelectionCopy,
            ...(conditions.selection.selectionStart.rowIndex === 0
                ? [BeeTableOperation.SelectionCut, BeeTableOperation.SelectionPaste, BeeTableOperation.SelectionReset]
                : []),
        ];
    }, []);
    return (_jsx("div", Object.assign({ className: `literal-expression` }, { children: _jsxs("div", Object.assign({ className: "literal-expression-body-container" }, { children: [_jsx("div", Object.assign({ className: "equals-sign" }, { children: `=` })), _jsx(BeeTable, { resizerStopBehavior: ResizerStopBehavior.SET_WIDTH_WHEN_SMALLER, forwardRef: beeTableRef, getRowKey: getRowKey, columns: beeTableColumns, rows: beeTableRows, headerVisibility: beeTableHeaderVisibility, onColumnUpdates: onColumnUpdates, onCellUpdates: onCellUpdates, operationConfig: beeTableOperationConfig, allowedOperations: allowedOperations, onColumnResizingWidthChange: onColumnResizingWidthChange, shouldRenderRowIndexColumn: false, shouldShowRowsInlineControls: false, shouldShowColumnsInlineControls: false })] })) })));
}
//# sourceMappingURL=LiteralExpression.js.map