"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setupWorkerConnection = void 0;
var common_1 = require("@kie-tools-core/envelope-bus/dist/common");
function setupWorkerConnection(args) {
    var bus = new common_1.EnvelopeBusMessageManager(function (m) {
        return args.port.postMessage(m);
    });
    args.port.addEventListener("message", function (message) { return bus.server.receive(message.data, args.apiImpl); });
    args.port.start();
    bus.clientApi.notifications.kieToolsWorkspacesWorker_ready.send();
    args.fsFlushManager.subscribable.subscribe(function (flushes) {
        bus.shared.kieSandboxWorkspacesStorage_flushes.set(flushes);
    });
}
exports.setupWorkerConnection = setupWorkerConnection;
//# sourceMappingURL=setupWorkerConnection.js.map