import React from "react";
import HelpIcon from "@patternfly/react-icons/dist/esm/icons/help-icon";
import { Popover } from "@patternfly/react-core/dist/js/components/Popover";
const CloudEventFieldLabelIcon = ({ fieldId, helpMessage, cloudEventHeader, }) => {
    return (React.createElement(Popover, { id: `cloudEvent-form-${fieldId}-help`, bodyContent: React.createElement("div", null,
            React.createElement("div", null, helpMessage),
            cloudEventHeader && (React.createElement("div", null,
                "The value will be set in the ",
                React.createElement("span", { className: "pf-u-success-color-100" }, `'${cloudEventHeader}'`),
                " ",
                "header."))) },
        React.createElement("button", { type: "button", "aria-label": `More info for ${fieldId} field`, onClick: (e) => e.preventDefault(), className: "pf-c-form__group-label-help" },
            React.createElement(HelpIcon, { noVerticalAlign: true }))));
};
export default CloudEventFieldLabelIcon;
//# sourceMappingURL=CloudEventFieldLabelIcon.js.map