import React, { useMemo, useState } from "react";
import { Dropdown, DropdownItem, KebabToggle } from "@patternfly/react-core/dist/js/components/Dropdown";
import { WorkflowInstanceState } from "@kie-tools/runtime-tools-swf-gateway-api/dist/types";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { checkWorkflowInstanceState } from "../utils/WorkflowListUtils";
const WorkflowListActionsKebab = ({ workflowInstance, onSkipClick, onRetryClick, onAbortClick, onOpenTriggerCloudEvent, ouiaId, ouiaSafe, }) => {
    const [isKebabOpen, setIsKebabOpen] = useState(false);
    const onSelect = () => {
        setIsKebabOpen(!isKebabOpen);
    };
    const onToggle = (isOpen) => {
        setIsKebabOpen(isOpen);
    };
    const dropDownList = useMemo(() => {
        const result = [];
        if (workflowInstance.state === WorkflowInstanceState.Error) {
            result.push(React.createElement(DropdownItem, { key: "Retry", onClick: () => onRetryClick(workflowInstance) }, "Retry"));
            result.push(React.createElement(DropdownItem, { key: "Skip", onClick: () => onSkipClick(workflowInstance) }, "Skip"));
        }
        if (onOpenTriggerCloudEvent) {
            result.push(React.createElement(DropdownItem, { key: "CloudEvent", onClick: () => onOpenTriggerCloudEvent(workflowInstance) }, "Send Cloud Event"));
        }
        result.push(React.createElement(DropdownItem, { key: "Abort", onClick: () => onAbortClick(workflowInstance) }, "Abort"));
        return result;
    }, [workflowInstance, onSkipClick, onRetryClick, onAbortClick, onOpenTriggerCloudEvent]);
    return (React.createElement(Dropdown, Object.assign({ onSelect: onSelect, toggle: React.createElement(KebabToggle, { isDisabled: checkWorkflowInstanceState(workflowInstance), onToggle: onToggle, id: "kebab-toggle" }), isOpen: isKebabOpen, isPlain: true, position: "right", "aria-label": "workflow instance actions dropdown", "aria-labelledby": "workflow instance actions dropdown", dropdownItems: dropDownList }, componentOuiaProps(ouiaId, "workflow-list-actions-kebab", ouiaSafe))));
};
export default WorkflowListActionsKebab;
//# sourceMappingURL=WorkflowListActionsKebab.js.map