import { getNewDmnIdRandomizer } from "../idRandomizer/dmnIdRandomizer";
import { addMissingImportNamespaces } from "../mutations/addMissingImportNamespaces";
export function normalize(model) {
    getNewDmnIdRandomizer()
        .ack({
        json: model.definitions.drgElement,
        type: "DMN15__tDefinitions",
        attr: "drgElement",
    })
        .ack({
        json: model.definitions.artifact,
        type: "DMN15__tDefinitions",
        attr: "artifact",
    })
        .ack({
        json: model.definitions["dmndi:DMNDI"],
        type: "DMN15__tDefinitions",
        attr: "dmndi:DMNDI",
    })
        .ack({
        json: model.definitions.import,
        type: "DMN15__tDefinitions",
        attr: "import",
    })
        .ack({
        json: model.definitions.itemDefinition,
        type: "DMN15__tDefinitions",
        attr: "itemDefinition",
    })
        .randomize({ skipAlreadyAttributedIds: true });
    var normalizedModel = model;
    addMissingImportNamespaces(normalizedModel.definitions);
    return normalizedModel;
}
//# sourceMappingURL=normalize.js.map