var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import * as React from "react";
import { useMemo, useState, useCallback, useRef, useEffect } from "react";
import { Text, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { Tooltip, TooltipPosition } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { PlusCircleIcon } from "@patternfly/react-icons/dist/js/icons/plus-circle-icon";
import { TimesIcon } from "@patternfly/react-icons/dist/js/icons/times-icon";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { AngleDownIcon } from "@patternfly/react-icons/dist/js/icons/angle-down-icon";
import { AngleRightIcon } from "@patternfly/react-icons/dist/js/icons/angle-right-icon";
import { InlineFeelNameInput, invalidInlineFeelNameStyle } from "../feel/InlineFeelNameInput";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { Draggable, DragAndDrop, useDraggableItemContext } from "../draggable/Draggable";
import "./DocumentationLinksFormGroup.css";
var PLACEHOLDER_URL_TITLE = "Enter a title...";
var PLACEHOLDER_URL = "https://...";
export function DocumentationLinksFormGroup(_a) {
    var _b;
    var isReadonly = _a.isReadonly, values = _a.values, onChange = _a.onChange;
    var _c = __read(useState(true), 2), autoFocusFirst = _c[0], setAutoFocusFirst = _c[1];
    var _d = __read(useState((_b = (values !== null && values !== void 0 ? values : [])) === null || _b === void 0 ? void 0 : _b.map(function (_) { return generateUuid(); })), 2), valuesUuid = _d[0], setValuesUuid = _d[1];
    var valuesCache = useRef(values !== null && values !== void 0 ? values : []);
    useEffect(function () {
        var _a;
        if (JSON.stringify(values) !== JSON.stringify(valuesCache.current)) {
            setValuesUuid((_a = (values !== null && values !== void 0 ? values : [])) === null || _a === void 0 ? void 0 : _a.map(function () { return generateUuid(); }));
            valuesCache.current = __spreadArray([], __read((values !== null && values !== void 0 ? values : [])), false);
        }
    }, [values]);
    var _e = __read(useState([]), 2), expandedUrls = _e[0], setExpandedUrls = _e[1];
    var onInternalChange = useCallback(function (newValues) {
        valuesCache.current = __spreadArray([], __read(newValues), false);
        onChange === null || onChange === void 0 ? void 0 : onChange(newValues);
    }, [onChange]);
    var onAdd = useCallback(function () {
        setAutoFocusFirst(true);
        var newValues = __spreadArray([], __read((values !== null && values !== void 0 ? values : [])), false);
        newValues.unshift({ "@_name": "", "@_url": "" });
        setExpandedUrls(function (prev) {
            var newUrlExpanded = __spreadArray([], __read(prev), false);
            newUrlExpanded.unshift(true);
            return newUrlExpanded;
        });
        setValuesUuid(function (prev) { return __spreadArray([generateUuid()], __read(prev), false); });
        onInternalChange(newValues);
    }, [onInternalChange, values]);
    var onChangeKieAttachment = useCallback(function (args) {
        var _a, _b, _c;
        setAutoFocusFirst(false);
        if (isReadonly) {
            return;
        }
        var newValues = __spreadArray([], __read((values !== null && values !== void 0 ? values : [])), false);
        var newKieAttachment = (_a = newValues[args.index]) !== null && _a !== void 0 ? _a : { "@_name": "", "@_url": "" };
        newValues[args.index] = {
            "@_name": (_b = args.newUrlTitle) !== null && _b !== void 0 ? _b : newKieAttachment["@_name"],
            "@_url": (_c = args.newUrl) !== null && _c !== void 0 ? _c : newKieAttachment["@_url"],
        };
        onInternalChange(newValues);
    }, [isReadonly, onInternalChange, values]);
    var onRemove = useCallback(function (index) {
        setAutoFocusFirst(false);
        var newValues = __spreadArray([], __read((values !== null && values !== void 0 ? values : [])), false);
        newValues.splice(index, 1);
        setValuesUuid(function (prev) {
            var newUuids = __spreadArray([], __read(prev), false);
            newUuids.splice(index, 1);
            return newUuids;
        });
        setExpandedUrls(function (prev) {
            var newUrlExpanded = __spreadArray([], __read(prev), false);
            newUrlExpanded.splice(index, 1);
            return newUrlExpanded;
        });
        onInternalChange(newValues);
    }, [onInternalChange, values]);
    var setUrlExpanded = useCallback(function (isExpanded, index) {
        setExpandedUrls(function (prev) {
            var newUrlExpanded = __spreadArray([], __read(prev), false);
            newUrlExpanded[index] = isExpanded;
            return newUrlExpanded;
        });
    }, []);
    var onDragEnd = useCallback(function (source, dest) {
        var reordened = __spreadArray([], __read((values !== null && values !== void 0 ? values : [])), false);
        var _a = __read(reordened.splice(source, 1), 1), removed = _a[0];
        reordened.splice(dest, 0, removed);
        onInternalChange(reordened);
    }, [onInternalChange, values]);
    var reorder = useCallback(function (source, dest) {
        setExpandedUrls(function (prev) {
            var newUrlExpanded = __spreadArray([], __read(prev), false);
            var _a = __read(newUrlExpanded.splice(source, 1), 1), removed = _a[0];
            newUrlExpanded.splice(dest, 0, removed);
            return newUrlExpanded;
        });
        setValuesUuid(function (prev) {
            var reordenedUuid = __spreadArray([], __read(prev), false);
            var _a = __read(reordenedUuid.splice(source, 1), 1), removedUuid = _a[0];
            reordenedUuid.splice(dest, 0, removedUuid);
            return reordenedUuid;
        });
    }, []);
    var draggableItem = useCallback(function (kieAttachment, index) {
        var _a, _b, _c;
        return (_jsx(Draggable, __assign({ index: index, rowClassName: index !== 0 ? "kie-dmn-editor--documentation-link--not-first-element" : "", handlerStyle: expandedUrls[index]
                ? { alignSelf: "flex-start", paddingTop: "8px", paddingLeft: "16px", paddingRight: "16px" }
                : { paddingLeft: "16px", paddingRight: "16px" }, isDisabled: isReadonly }, { children: _jsx("li", { children: _jsx(DocumentationLinksInput, { title: (_a = kieAttachment["@_name"]) !== null && _a !== void 0 ? _a : "", url: (_b = kieAttachment["@_url"]) !== null && _b !== void 0 ? _b : "", isReadonly: isReadonly, onChange: function (newUrlTitle, newUrl) { return onChangeKieAttachment({ newUrlTitle: newUrlTitle, newUrl: newUrl, index: index }); }, onRemove: function () { return onRemove(index); }, isUrlExpanded: expandedUrls[index], setUrlExpanded: function (isExpanded) { return setUrlExpanded(isExpanded, index); }, autoFocus: autoFocusFirst ? index === 0 : false }) }) }), (_c = valuesUuid === null || valuesUuid === void 0 ? void 0 : valuesUuid[index]) !== null && _c !== void 0 ? _c : generateUuid()));
    }, [autoFocusFirst, expandedUrls, isReadonly, onChangeKieAttachment, onRemove, setUrlExpanded, valuesUuid]);
    return (_jsx(FormGroup, __assign({ label: _jsxs("div", __assign({ style: { display: "flex", flexDirection: "row" } }, { children: [_jsx("label", __assign({ className: "pf-c-form__label", style: { flexGrow: 1, cursor: "auto" } }, { children: _jsx("span", __assign({ className: "pf-c-form__label-text" }, { children: "Documentation links" })) })), !isReadonly && (_jsx(Button, { variant: "plain", icon: _jsx(PlusCircleIcon, {}), onClick: onAdd, title: "Add documentation link" }))] })) }, { children: _jsxs("ul", { children: [(values !== null && values !== void 0 ? values : []).length === 0 && (_jsx("li", __assign({ className: "kie-dmn-editor--documentation-link--empty-state" }, { children: isReadonly ? "None" : "None yet" }))), _jsx(DragAndDrop, { reorder: reorder, onDragEnd: onDragEnd, values: values, draggableItem: draggableItem, isDisabled: isReadonly })] }) })));
}
function DocumentationLinksInput(_a) {
    var title = _a.title, url = _a.url, isReadonly = _a.isReadonly, isUrlExpanded = _a.isUrlExpanded, onChange = _a.onChange, onRemove = _a.onRemove, setUrlExpanded = _a.setUrlExpanded, parentAutoFocus = _a.autoFocus;
    var urlTitleRef = useRef(null);
    var uuid = useMemo(function () { return generateUuid(); }, []);
    var _b = __read(useState(false), 2), titleIsUrl = _b[0], setTitleIsUrl = _b[1];
    var updatedOnToogle = useRef(false);
    var hovered = useDraggableItemContext().hovered;
    var _c = __read(useState(false), 2), autoFocus = _c[0], setAutoFocus = _c[1];
    var parseUrl = useCallback(function (newUrl) {
        try {
            var url_1 = new URL(newUrl);
            return url_1.toString();
        }
        catch (error) {
            try {
                if (!newUrl.includes("http://") && !newUrl.includes("https://")) {
                    var urlWithProtocol = "https://" + newUrl + "/";
                    var url_2 = new URL(urlWithProtocol);
                    return url_2.toString() === urlWithProtocol ? url_2.toString() : undefined;
                }
            }
            catch (error) {
                return undefined;
            }
            return undefined;
        }
    }, []);
    var toogleExpanded = useCallback(function (title, url) {
        var parsedUrl = parseUrl(url);
        if (parsedUrl !== undefined && isUrlExpanded === true && (title === "" || titleIsUrl)) {
            setTitleIsUrl(true);
            updatedOnToogle.current = true;
            onChange(parsedUrl, parsedUrl);
            setUrlExpanded(false);
            setAutoFocus(false);
        }
        else if (parsedUrl !== undefined && parsedUrl !== url && isUrlExpanded === true) {
            updatedOnToogle.current = true;
            onChange(title, parsedUrl);
            setUrlExpanded(false);
            setAutoFocus(false);
        }
        else if (url !== "" && parsedUrl === undefined && title === "") {
            updatedOnToogle.current = true;
            onChange("", url);
        }
        else if (url !== "" && parsedUrl === undefined) {
        }
        else {
            setUrlExpanded(!isUrlExpanded);
            setAutoFocus(!isUrlExpanded);
        }
    }, [isUrlExpanded, titleIsUrl, parseUrl, setUrlExpanded, onChange]);
    var isUrl = useMemo(function () {
        try {
            return new URL(url) && !isUrlExpanded;
        }
        catch (error) {
            return false;
        }
    }, [url, isUrlExpanded]);
    var allUniqueNames = useMemo(function () { return new Map(); }, []);
    var validateTitle = useCallback(function (id, name, allUniqueNames) { return true; }, []);
    var validateUrl = useCallback(function (id, url, allUniqueNames) {
        if (url !== undefined && url !== "") {
            return parseUrl(url) !== undefined;
        }
        return true;
    }, [parseUrl]);
    var urlDescriptionTooltip = useMemo(function () {
        return url !== "" ? (_jsx(Text, __assign({ component: TextVariants.p }, { children: url }))) : (_jsx(Text, __assign({ component: TextVariants.p }, { children: "Empty URL" })));
    }, [url]);
    var removeTooltip = useMemo(function () { return _jsx(Text, __assign({ component: TextVariants.p }, { children: "Remove" })); }, []);
    return (_jsx(React.Fragment, { children: _jsxs("div", __assign({ className: "kie-dmn-editor--documentation-link--row", "data-testid": "kie-tools--dmn-editor--documentation-link--row" }, { children: [_jsx(Button, __assign({ title: "Expand / collapse documentation link", variant: ButtonVariant.plain, className: "kie-dmn-editor--documentation-link--row-expand-toogle", onClick: function () { return toogleExpanded(title, url); } }, { children: (isUrlExpanded && _jsx(AngleDownIcon, {})) || _jsx(AngleRightIcon, {}) })), _jsx("div", __assign({ className: "kie-dmn-editor--documentation-link--row-item" }, { children: !isUrlExpanded ? (_jsxs(_Fragment, { children: [_jsx("div", __assign({ ref: urlTitleRef, className: "kie-dmn-editor--documentation-link--row-title" }, { children: isUrl ? (_jsx("a", __assign({ href: url, target: "_blank", "data-testid": "kie-tools--dmn-editor--documentation-link--row-title" }, { children: title }))) : (_jsx("p", __assign({ style: title === "" ? {} : invalidInlineFeelNameStyle, onClick: function () { return setUrlExpanded(true); } }, { children: title !== "" ? title : PLACEHOLDER_URL_TITLE }))) })), !isUrlExpanded && (_jsx(Tooltip, { content: urlDescriptionTooltip, position: TooltipPosition.topStart, reference: urlTitleRef }))] })) : (_jsxs("div", __assign({ className: "kie-dmn-editor--documentation-link--row-inputs" }, { children: [_jsx(InlineFeelNameInput, { isPlain: true, isReadonly: isReadonly, id: "".concat(uuid, "-name"), shouldCommitOnBlur: true, placeholder: PLACEHOLDER_URL_TITLE, name: title !== null && title !== void 0 ? title : "", onRenamed: function (newUrlTitle) {
                                    if (!updatedOnToogle.current && newUrlTitle !== title) {
                                        onChange(newUrlTitle, url);
                                        setTitleIsUrl(false);
                                    }
                                    updatedOnToogle.current = false;
                                }, allUniqueNames: function () { return allUniqueNames; }, validate: validateTitle, autoFocus: parentAutoFocus || autoFocus, onKeyDown: function (e) {
                                    if (e.code === "Enter") {
                                        toogleExpanded(e.currentTarget.value, url);
                                    }
                                } }), _jsx(InlineFeelNameInput, { className: "kie-dmn-editor--documentation-link--row-inputs-url", isPlain: true, isReadonly: isReadonly, id: "".concat(uuid, "-url"), shouldCommitOnBlur: true, placeholder: PLACEHOLDER_URL, name: url !== null && url !== void 0 ? url : "", onRenamed: function (newUrl) {
                                    if (!updatedOnToogle.current && newUrl !== url) {
                                        onChange(title, newUrl);
                                    }
                                    updatedOnToogle.current = false;
                                }, allUniqueNames: function () { return allUniqueNames; }, validate: validateUrl, saveInvalidValue: true, onKeyDown: function (e) {
                                    if (e.code === "Enter") {
                                        toogleExpanded(title, e.currentTarget.value);
                                    }
                                } })] }))) })), hovered && (_jsx(Tooltip, __assign({ content: removeTooltip }, { children: _jsx(Button, { title: "Remove documentation link", className: "kie-dmn-editor--documentation-link--row-remove", variant: "plain", icon: _jsx(TimesIcon, {}), onClick: function () { return onRemove(); } }) })))] })) }));
}
//# sourceMappingURL=DocumentationLinksFormGroup.js.map