var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { ClipboardCopy } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { TextArea } from "@patternfly/react-core/dist/js/components/TextArea";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { useDmnEditorStoreApi } from "../store/StoreContext";
import { renameGroupNode } from "../mutations/renameNode";
export function GroupProperties(_a) {
    var _b;
    var group = _a.group, index = _a.index;
    var setState = useDmnEditorStoreApi().setState;
    return (_jsxs(_Fragment, { children: [_jsx(FormGroup, __assign({ label: "Name" }, { children: _jsx(TextInput, { "aria-label": "Name", type: "text", isDisabled: false, onChange: function (newName) {
                        setState(function (state) {
                            renameGroupNode({
                                definitions: state.dmn.model.definitions,
                                index: index,
                                newName: newName,
                            });
                        });
                    }, value: group["@_name"], placeholder: "Enter a name..." }) })), _jsx(FormGroup, __assign({ label: "Description" }, { children: _jsx(TextArea, { "aria-label": "Description", type: "text", isDisabled: false, value: (_b = group.description) === null || _b === void 0 ? void 0 : _b.__$$text, onChange: function (newDescription) {
                        setState(function (state) {
                            state.dmn.model.definitions.artifact[index].description = {
                                __$$text: newDescription,
                            };
                        });
                    }, placeholder: "Enter a description...", style: { resize: "vertical", minHeight: "40px" }, rows: 6 }) })), _jsx(FormGroup, __assign({ label: "ID" }, { children: _jsx(ClipboardCopy, __assign({ isReadOnly: true, hoverTip: "Copy", clickTip: "Copied" }, { children: group["@_id"] })) }))] }));
}
//# sourceMappingURL=GroupProperties.js.map