import { getNamespaceOfDmnImport } from "../../includedModels/importNamespaces";
export function computeExternalModelsByType(imports, externalModelsByNamespace) {
    return (imports !== null && imports !== void 0 ? imports : []).reduce(function (acc, _import) {
        var externalModel = externalModelsByNamespace === null || externalModelsByNamespace === void 0 ? void 0 : externalModelsByNamespace[getNamespaceOfDmnImport({ dmnImport: _import })];
        if (!externalModel) {
            console.warn("DMN DIAGRAM: Can't index external model with namespace '".concat(_import["@_namespace"], "' because it doesn't exist on the external models list."));
            return acc;
        }
        if (externalModel.type === "dmn") {
            acc.dmns.set(_import["@_namespace"], externalModel);
        }
        else if (externalModel.type === "pmml") {
            acc.pmmls.set(_import["@_namespace"], externalModel);
        }
        else {
            console.warn("DMN EDITOR: Unknown external model type", externalModel);
        }
        return acc;
    }, { dmns: new Map(), pmmls: new Map() });
}
//# sourceMappingURL=computeExternalModelsByType.js.map