"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decisionCompletion = void 0;
exports.decisionCompletion = "specVersion: alpha\nkind: YaRD\nname: 'Traffic Violation'\nexpressionLang: alpha\ninputs:\n - name: 'Driver'\n   type: 'http://myapi.org/jsonSchema.json#Driver'\n - name: 'Violation'\n   type: 'http://myapi.org/jsonSchema.json#Violation'\nelements:\n - name: 'Fine'\n   type: Decision\n   requirements: ['Violation']\n   logic:\n     type: DecisionTable\n     inputs: ['Violation.type', 'Violation.Speed - Violation.SpeedLimit']\n     outputComponents: ['Amount', 'Points']\n     rules:\n      - ['=\"speed\"', '[10..30)', 500, 3]\n      - ['=\"speed\"', '>= 30', 1000, 7]\n      - ['=\"parking\"', '-', 100, 1]\n      - ['=\"driving under the influence\"', '-', 1000, 5]\n - name: 'Should the driver be suspended?'\n   type: Decision\n   requirements: ['Driver', 'Fine']\n   logic:\n     type: LiteralExpression\n     expression: 'if Driver.Points + Fine.Points >= 20 then \"Yes\" else \"No\"'";
//# sourceMappingURL=decision-completion.js.map