import { FormElementTemplate, FormElementTemplateProps } from "./types";
import { CodeFragment, FormInput } from "../../api";
export interface Option {
    value: string;
    label: string;
    checked: boolean;
}
export interface SelectFieldProps extends FormElementTemplateProps<string> {
    placeHolder: string;
    multiple: boolean;
    options: Option[];
}
export declare class SelectFieldTemplate implements FormElementTemplate<FormInput, SelectFieldProps> {
    private readonly inputTemplate;
    private readonly setValueFromModelTemplate;
    private readonly writeValueToModelTemplate;
    constructor();
    render(props: SelectFieldProps): FormInput;
    protected buildSetValueFromModelCode(props: SelectFieldProps): CodeFragment;
    protected writeValueToModelCode(props: SelectFieldProps): CodeFragment | undefined;
}
//# sourceMappingURL=SelectFieldTemplate.d.ts.map