"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var react_sortable_hoc_1 = require("react-sortable-hoc");
var Button_1 = require("@patternfly/react-core/dist/js/components/Button");
var Flex_1 = require("@patternfly/react-core/dist/js/layouts/Flex");
var Label_1 = require("@patternfly/react-core/dist/js/components/Label");
var grip_vertical_icon_1 = require("@patternfly/react-icons/dist/js/icons/grip-vertical-icon");
require("./DataTypesSort.scss");
var DataTypesSort = function (_a) {
    var dataTypes = _a.dataTypes, onReorder = _a.onReorder;
    var _b = __read((0, react_1.useState)(dataTypes), 2), state = _b[0], setState = _b[1];
    var onSortEnd = function (_a) {
        var oldIndex = _a.oldIndex, newIndex = _a.newIndex;
        var newOrder = reorder(state, oldIndex, newIndex);
        setState(newOrder);
        onReorder(oldIndex, newIndex);
    };
    var getHelperClass = function () {
        if (state.length >= 8) {
            return "data-type-item__sortable--sm-size";
        }
        if (state.length >= 5) {
            return "data-type-item__sortable--md-size";
        }
    };
    (0, react_1.useEffect)(function () {
        setState(dataTypes);
    }, [dataTypes]);
    return (0, jsx_runtime_1.jsx)(SortableList, { items: state, onSortEnd: onSortEnd, lockAxis: "y", helperClass: getHelperClass() });
};
exports.default = DataTypesSort;
var SortableList = (0, react_sortable_hoc_1.SortableContainer)(function (_a) {
    var items = _a.items;
    return ((0, jsx_runtime_1.jsx)("ul", __assign({ className: "data-types-sorting" }, { children: items.map(function (item, index) { return ((0, jsx_runtime_1.jsx)(SortableItem, { index: index, item: item }, "item-".concat(item.name))); }) })));
});
var SortableItem = (0, react_sortable_hoc_1.SortableElement)(function (_a) {
    var item = _a.item;
    return ((0, jsx_runtime_1.jsx)("li", __assign({ className: "editable-item data-type-item__sortable" }, { children: (0, jsx_runtime_1.jsx)("section", __assign({ className: "editable-item__inner", "data-ouia-component-id": item.name }, { children: (0, jsx_runtime_1.jsxs)(Flex_1.Flex, __assign({ alignItems: { default: "alignItemsCenter" } }, { children: [(0, jsx_runtime_1.jsx)(Flex_1.FlexItem, __assign({ spacer: { default: "spacerXs" } }, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: "plain", "aria-label": "Drag to sort", component: "span", ouiaId: "drag-it" }, { children: (0, jsx_runtime_1.jsx)(grip_vertical_icon_1.GripVerticalIcon, {}) })) })), (0, jsx_runtime_1.jsx)(Flex_1.FlexItem, { children: (0, jsx_runtime_1.jsx)("strong", { children: item.name }) }), (0, jsx_runtime_1.jsxs)(Flex_1.FlexItem, { children: [(0, jsx_runtime_1.jsx)(Label_1.Label, __assign({ color: "blue" }, { children: item.type })), " ", (0, jsx_runtime_1.jsx)(Label_1.Label, __assign({ color: "blue" }, { children: item.optype }))] })] })) })) })));
});
var reorder = function (list, startIndex, endIndex) {
    var result = __spreadArray([], __read(list), false);
    var _a = __read(result.splice(startIndex, 1), 1), removed = _a[0];
    result.splice(endIndex, 0, removed);
    return result;
};
//# sourceMappingURL=DataTypesSort.js.map