"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsCodeKieEditorCustomDocument = void 0;
var vscode = require("vscode");
var vscode_1 = require("vscode");
var VsCodeOutputLogger_1 = require("./VsCodeOutputLogger");
var onSaveHook_1 = require("./onSaveHook");
var workspaceRoot_1 = require("./workspace/workspaceRoot");
var __path = require("path");
var VsCodeKieEditorCustomDocument = (function () {
    function VsCodeKieEditorCustomDocument(uri, initialBackup, editorStore, vsCodeI18n, vscodeNotifications, editorEnvelopeLocator) {
        this.uri = uri;
        this.initialBackup = initialBackup;
        this.editorStore = editorStore;
        this.vsCodeI18n = vsCodeI18n;
        this.vscodeNotifications = vscodeNotifications;
        this.editorEnvelopeLocator = editorEnvelopeLocator;
        this.encoder = new TextEncoder();
        this.decoder = new TextDecoder("utf-8");
        this.vsCodeLogger = new VsCodeOutputLogger_1.VsCodeOutputLogger(VsCodeKieEditorCustomDocument.name);
        this._onDidDispose = new vscode_1.EventEmitter();
        this.onDidDispose = this._onDidDispose.event;
        this._onDidChange = new vscode_1.EventEmitter();
        this.onDidChange = this._onDidChange.event;
    }
    VsCodeKieEditorCustomDocument.prototype.dispose = function () {
        this._onDidDispose.fire();
        this._onDidDispose.dispose();
        this._onDidChange.dispose();
    };
    Object.defineProperty(VsCodeKieEditorCustomDocument.prototype, "normalizedPosixPathRelativeToTheWorkspaceRoot", {
        get: function () {
            return (0, workspaceRoot_1.getNormalizedPosixPathRelativeToWorkspaceRoot)(this);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(VsCodeKieEditorCustomDocument.prototype, "fileExtension", {
        get: function () {
            var lastSlashIndex = this.uri.path.lastIndexOf("/");
            var fileName = this.uri.path.substring(lastSlashIndex + 1);
            var firstDotIndex = fileName.indexOf(".");
            var fileExtension = fileName.substring(firstDotIndex + 1);
            return fileExtension;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(VsCodeKieEditorCustomDocument.prototype, "fileType", {
        get: function () {
            var _a;
            return (_a = this.editorEnvelopeLocator.getEnvelopeMapping(this.uri.fsPath)) === null || _a === void 0 ? void 0 : _a.type;
        },
        enumerable: false,
        configurable: true
    });
    VsCodeKieEditorCustomDocument.prototype.save = function (destination, cancellation) {
        return __awaiter(this, void 0, void 0, function () {
            var i18n, editor, notifications, e_1, content, e_2;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        i18n = this.vsCodeI18n.getCurrent();
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 8, , 9]);
                        editor = this.editorStore.get(this.uri);
                        if (!editor) {
                            this.vsCodeLogger.error("Cannot save because there's no open Editor for ".concat(this.uri.fsPath));
                            return [2];
                        }
                        _a.label = 2;
                    case 2:
                        _a.trys.push([2, 4, , 5]);
                        return [4, editor.validate()];
                    case 3:
                        notifications = _a.sent();
                        this.vscodeNotifications.setNotifications(this, __path.posix.normalize(__path.relative((0, workspaceRoot_1.getWorkspaceRoot)(this).workspaceRootAbsoluteFsPath, destination.fsPath)), notifications);
                        return [3, 5];
                    case 4:
                        e_1 = _a.sent();
                        this.vsCodeLogger.warn("File was not validated: ".concat(e_1));
                        return [3, 5];
                    case 5: return [4, editor.getContent()];
                    case 6:
                        content = _a.sent();
                        if (cancellation.isCancellationRequested) {
                            this.vsCodeLogger.info(cancellation);
                            return [2];
                        }
                        return [4, vscode.workspace.fs.writeFile(destination, this.encoder.encode(content))];
                    case 7:
                        _a.sent();
                        (0, onSaveHook_1.executeOnSaveHook)(this.fileType);
                        vscode.window.setStatusBarMessage(i18n.savedSuccessfully, 3000);
                        return [3, 9];
                    case 8:
                        e_2 = _a.sent();
                        this.vsCodeLogger.error("Error saving. ".concat(e_2));
                        return [3, 9];
                    case 9: return [2];
                }
            });
        });
    };
    VsCodeKieEditorCustomDocument.prototype.backup = function (destination, cancellation) {
        return __awaiter(this, void 0, void 0, function () {
            var editor, customDocumentBackup, content;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        editor = this.editorStore.get(this.uri);
                        if (!editor) {
                            throw new Error("Cannot proceed with backup. Editor is null for path ".concat(this.uri.fsPath, "."));
                        }
                        customDocumentBackup = {
                            id: destination.fsPath,
                            delete: function () { return vscode.workspace.fs.delete(destination); },
                        };
                        if (cancellation.isCancellationRequested) {
                            return [2, customDocumentBackup];
                        }
                        return [4, editor.getContent()];
                    case 1:
                        content = _a.sent();
                        return [4, vscode.workspace.fs.writeFile(destination, this.encoder.encode(content))];
                    case 2:
                        _a.sent();
                        console.info("Backup saved.");
                        return [2, customDocumentBackup];
                }
            });
        });
    };
    VsCodeKieEditorCustomDocument.prototype.revert = function (cancellation) {
        return __awaiter(this, void 0, void 0, function () {
            var input, editor;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, vscode.workspace.fs.readFile(this.uri)];
                    case 1:
                        input = _a.sent();
                        editor = this.editorStore.get(this.uri);
                        if (editor) {
                            return [2, editor.setContent(this.normalizedPosixPathRelativeToTheWorkspaceRoot, this.decoder.decode(input))];
                        }
                        return [2];
                }
            });
        });
    };
    VsCodeKieEditorCustomDocument.prototype.notifyEdit = function (editor, edit) {
        var _this = this;
        this._onDidChange.fire({
            label: "edit",
            document: this,
            undo: function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                return [2, editor.undo()];
            }); }); },
            redo: function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                return [2, editor.redo()];
            }); }); },
        });
    };
    return VsCodeKieEditorCustomDocument;
}());
exports.VsCodeKieEditorCustomDocument = VsCodeKieEditorCustomDocument;
//# sourceMappingURL=VsCodeKieEditorCustomDocument.js.map