import { parseXmlHref } from "@kie-tools/dmn-marshaller/dist/xml/xmlHrefs";
import { getNewDmnIdRandomizer } from "@kie-tools/dmn-marshaller/dist/idRandomizer/dmnIdRandomizer";
import { NodeNature, nodeNatures } from "../mutations/NodeNature";
export const DMN_EDITOR_DIAGRAM_CLIPBOARD_MIME_TYPE = "application/json+kie-dmn-editor--diagram";
export const DMN_EDITOR_BOXED_EXPRESSION_CLIPBOARD_MIME_TYPE = "application/json+kie-dmn-editor--boxed-expression";
export const DMN_EDITOR_DATA_TYPES_CLIPBOARD_MIME_TYPE = "application/json+kie-dmn-editor--data-types";
export function buildClipboardFromDiagram(rfState, dmnEditorState) {
    var _a, _b, _c, _d, _e, _f;
    const copiedEdgesById = new Map();
    const copiedNodesById = new Map();
    const danglingEdgesById = new Map();
    const nodesById = rfState
        .getNodes()
        .reduce((acc, n) => acc.set(n.id, n), new Map());
    const selectedNodesById = rfState
        .getNodes()
        .reduce((acc, n) => (n.selected ? acc.set(n.id, n) : acc), new Map());
    const clipboard = [...selectedNodesById.values()].reduce((acc, _node) => {
        var _a, _b, _c;
        function accNode(node) {
            var _a;
            const nodeNature = nodeNatures[node.type];
            if (nodeNature === NodeNature.ARTIFACT) {
                acc.artifacts.unshift(node.data.dmnObject);
            }
            else if (nodeNature === NodeNature.DRG_ELEMENT) {
                if (_node.data.dmnObjectQName.prefix) {
                    return;
                }
                const dmnObject = JSON.parse(JSON.stringify(node.data.dmnObject));
                if (((_a = node.data.dmnObject) === null || _a === void 0 ? void 0 : _a.__$$element) === "decisionService") {
                    dmnObject.inputData = [];
                    dmnObject.inputDecision = [];
                }
                if (dmnObject.authorityRequirement) {
                    dmnObject.authorityRequirement = dmnObject.authorityRequirement.filter((s) => {
                        var _a, _b, _c, _d, _e, _f;
                        return (s.requiredInput &&
                            selectedNodesById.has(s.requiredInput["@_href"]) &&
                            !((_b = (_a = selectedNodesById.get(s.requiredInput["@_href"])) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.dmnObjectQName.prefix)) ||
                            (s.requiredDecision &&
                                selectedNodesById.has(s.requiredDecision["@_href"]) &&
                                !((_d = (_c = selectedNodesById.get(s.requiredDecision["@_href"])) === null || _c === void 0 ? void 0 : _c.data) === null || _d === void 0 ? void 0 : _d.dmnObjectQName.prefix)) ||
                            (s.requiredAuthority &&
                                selectedNodesById.has(s.requiredAuthority["@_href"]) &&
                                !((_f = (_e = selectedNodesById.get(s.requiredAuthority["@_href"])) === null || _e === void 0 ? void 0 : _e.data) === null || _f === void 0 ? void 0 : _f.dmnObjectQName.prefix));
                    });
                }
                if (dmnObject.knowledgeRequirement) {
                    dmnObject.knowledgeRequirement = dmnObject.knowledgeRequirement.filter((s) => {
                        var _a, _b;
                        return selectedNodesById.has(s.requiredKnowledge["@_href"]) &&
                            !((_b = (_a = selectedNodesById.get(s.requiredKnowledge["@_href"])) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.dmnObjectQName.prefix);
                    });
                }
                if (dmnObject.informationRequirement) {
                    dmnObject.informationRequirement = dmnObject.informationRequirement.filter((s) => {
                        var _a, _b, _c, _d;
                        return (s.requiredInput &&
                            selectedNodesById.has(s.requiredInput["@_href"]) &&
                            !((_b = (_a = selectedNodesById.get(s.requiredInput["@_href"])) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.dmnObjectQName.prefix)) ||
                            (s.requiredDecision &&
                                selectedNodesById.has(s.requiredDecision["@_href"]) &&
                                !((_d = (_c = selectedNodesById.get(s.requiredDecision["@_href"])) === null || _c === void 0 ? void 0 : _c.data) === null || _d === void 0 ? void 0 : _d.dmnObjectQName.prefix));
                    });
                }
                acc.drgElements.unshift(dmnObject);
            }
            else if (nodeNature === NodeNature.UNKNOWN) {
            }
            else {
                throw new Error(`Unknwon node nature '${nodeNature}'`);
            }
            copiedNodesById.set(node.id, node);
            const { index, ...dmnShape } = node.data.shape;
            acc.shapes.push(dmnShape);
        }
        if (!_node.selected) {
            return acc;
        }
        if (((_a = _node.data.dmnObject) === null || _a === void 0 ? void 0 : _a.__$$element) === "decisionService") {
            for (const decision of [
                ...((_b = _node.data.dmnObject.outputDecision) !== null && _b !== void 0 ? _b : []),
                ...((_c = _node.data.dmnObject.encapsulatedDecision) !== null && _c !== void 0 ? _c : []),
            ]) {
                if (parseXmlHref(decision["@_href"]).namespace) {
                    continue;
                }
                const decisionNode = nodesById.get(decision["@_href"]);
                if (!decisionNode) {
                    continue;
                }
                accNode(decisionNode);
            }
        }
        accNode(_node);
        return acc;
    }, {
        mimeType: DMN_EDITOR_DIAGRAM_CLIPBOARD_MIME_TYPE,
        namespaceWhereClipboardWasCreatedFrom: dmnEditorState.dmn.model.definitions["@_namespace"],
        widths: [],
        drgElements: [],
        artifacts: [],
        shapes: [],
        edges: [],
    });
    const idsOnDrgElementTrees = getNewDmnIdRandomizer()
        .ack({ json: clipboard.drgElements, type: "DMN15__tDefinitions", attr: "drgElement" })
        .getOriginalIds();
    clipboard.widths = ((_e = (_d = (_c = (_b = (_a = dmnEditorState.dmn.model.definitions["dmndi:DMNDI"]) === null || _a === void 0 ? void 0 : _a["dmndi:DMNDiagram"]) === null || _b === void 0 ? void 0 : _b[dmnEditorState.computed(dmnEditorState).getDrdIndex()]["di:extension"]) === null || _c === void 0 ? void 0 : _c["kie:ComponentsWidthsExtension"]) === null || _d === void 0 ? void 0 : _d["kie:ComponentWidths"]) !== null && _e !== void 0 ? _e : []).filter((w) => idsOnDrgElementTrees.has(w["@_dmnElementRef"]));
    const artifacts = (_f = dmnEditorState.dmn.model.definitions.artifact) !== null && _f !== void 0 ? _f : [];
    clipboard.edges = rfState.edges.flatMap((edge) => {
        var _a, _b;
        if (copiedNodesById.has(edge.source) && !copiedNodesById.has(edge.target)) {
            danglingEdgesById.set(edge.id, edge);
        }
        if (copiedNodesById.has(edge.source) && copiedNodesById.has(edge.target)) {
            if (!((_a = edge.data) === null || _a === void 0 ? void 0 : _a.dmnEdge)) {
                return [];
            }
            copiedEdgesById.set(edge.id, edge);
            const { index, ...dmnEdge } = edge.data.dmnEdge;
            if (((_b = edge.data) === null || _b === void 0 ? void 0 : _b.dmnObject.requirementType) === "association") {
                clipboard.artifacts.push(artifacts[edge.data.dmnObject.index]);
            }
            return dmnEdge !== null && dmnEdge !== void 0 ? dmnEdge : [];
        }
        else {
            return [];
        }
    });
    return { clipboard, copiedEdgesById, copiedNodesById, danglingEdgesById };
}
export function buildClipboardFromDataType(dataType, thisDmnsNamespace) {
    return {
        namespaceWhereClipboardWasCreatedFrom: thisDmnsNamespace,
        namespace: dataType.namespace,
        mimeType: DMN_EDITOR_DATA_TYPES_CLIPBOARD_MIME_TYPE,
        itemDefinitions: [dataType.itemDefinition],
    };
}
export function getClipboard(text, mimeType) {
    let potentialClipboard;
    try {
        potentialClipboard = JSON.parse(text);
    }
    catch (e) {
        console.debug("DMN DIAGRAM: Ignoring pasted content. Not a valid JSON.");
        return undefined;
    }
    if (!potentialClipboard || potentialClipboard.mimeType !== mimeType) {
        console.debug("DMN DIAGRAM: Ignoring pasted content. MIME type doesn't match.");
        return undefined;
    }
    return potentialClipboard;
}
//# sourceMappingURL=Clipboard.js.map