import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback } from "react";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import CogIcon from "@patternfly/react-icons/dist/esm/icons/cog-icon";
import EditIcon from "@patternfly/react-icons/dist/esm/icons/edit-alt-icon";
import InfoIcon from "@patternfly/react-icons/dist/esm/icons/info-icon";
import { useTestScenarioEditorI18n } from "../i18n";
import { TestScenarioEditorDock } from "../store/TestScenarioEditorStore";
import { useTestScenarioEditorStore, useTestScenarioEditorStoreApi } from "../store/TestScenarioStoreContext";
import "./TestScenarioSideBarMenu.css";
function TestScenarioSideBarMenu() {
    const { i18n } = useTestScenarioEditorI18n();
    const navigation = useTestScenarioEditorStore((state) => state.navigation);
    const testScenarioEditorStoreApi = useTestScenarioEditorStoreApi();
    const isSelectedMenuItem = useCallback((item) => {
        return navigation.dock.isOpen && navigation.dock.selected === item;
    }, [navigation.dock]);
    const updateSelectedDock = useCallback((selected) => {
        testScenarioEditorStoreApi.setState((state) => {
            state.navigation.dock.isOpen = true;
            state.navigation.dock.selected = selected;
        });
    }, [testScenarioEditorStoreApi]);
    return (_jsxs("div", { className: "kie-scesim-editor--side-bar", children: [_jsx(Tooltip, { content: i18n.sidebar.dataSelectorTooltip, children: _jsx(Button, { className: isSelectedMenuItem(TestScenarioEditorDock.DATA_OBJECT)
                        ? "kie-scesim-editor-side-bar-menu--button-selected"
                        : "kie-scesim-editor-side-bar-menu--button", variant: "plain", onClick: () => updateSelectedDock(TestScenarioEditorDock.DATA_OBJECT), icon: _jsx(EditIcon, {}) }) }), _jsx(Tooltip, { content: i18n.sidebar.cheatSheetTooltip, children: _jsx(Button, { className: isSelectedMenuItem(TestScenarioEditorDock.CHEATSHEET)
                        ? "kie-scesim-editor-side-bar-menu--button-selected"
                        : "kie-scesim-editor-side-bar-menu--button", icon: _jsx(InfoIcon, {}), onClick: () => updateSelectedDock(TestScenarioEditorDock.CHEATSHEET), variant: "plain" }) }), _jsx(Tooltip, { content: _jsx("div", { children: i18n.sidebar.settingsTooltip }), children: _jsx(Button, { className: isSelectedMenuItem(TestScenarioEditorDock.SETTINGS)
                        ? "kie-scesim-editor-side-bar-menu--button-selected"
                        : "kie-scesim-editor-side-bar-menu--button", icon: _jsx(CogIcon, {}), onClick: () => updateSelectedDock(TestScenarioEditorDock.SETTINGS), variant: "plain" }) })] }));
}
export default TestScenarioSideBarMenu;
//# sourceMappingURL=TestScenarioSideBarMenu.js.map