import { SceSimModel } from "@kie-tools/scesim-marshaller";
import { SceSim__FactMappingType } from "@kie-tools/scesim-marshaller/dist/schemas/scesim-1_8/ts-gen/types";
import { ExternalDmnsIndex } from "../TestScenarioEditor";
import { ComputedStateCache } from "./ComputedStateCache";
export declare enum TestScenarioEditorDock {
    CHEATSHEET = 0,
    DATA_OBJECT = 1,
    SETTINGS = 2
}
export declare enum TestScenarioEditorTab {
    BACKGROUND = 0,
    SIMULATION = 1
}
export type TestScenarioAlert = {
    enabled: boolean;
    message?: string;
    variant: "success" | "danger" | "warning" | "info" | "default";
};
export type TestScenarioDataObject = {
    id: string;
    children?: TestScenarioDataObject[];
    className?: string;
    collectionGenericType?: string[];
    customBadgeContent?: string;
    expressionElements: string[];
    hasBadge?: boolean;
    name: string;
};
export type TestScenarioSelectedColumnMetaData = {
    factMapping: SceSim__FactMappingType;
    index: number;
    isBackground: boolean;
};
export interface State {
    computed: (s: State) => Computed;
    dispatch: (s: State) => Dispatch;
    navigation: {
        dock: {
            isOpen: boolean;
            selected: TestScenarioEditorDock;
        };
        tab: TestScenarioEditorTab;
    };
    scesim: {
        model: SceSimModel;
    };
    table: {
        background: {
            selectedColumn: TestScenarioSelectedColumnMetaData | null;
        };
        simulation: {
            selectedColumn: TestScenarioSelectedColumnMetaData | null;
        };
    };
}
export type Computed = {
    getDataObjects(externalModelsByNamespace: ExternalDmnsIndex | undefined): TestScenarioDataObject[];
    getDmnDataObjects(externalModelsByNamespace: ExternalDmnsIndex | undefined): TestScenarioDataObject[];
    getTestScenarioDataObjects(): TestScenarioDataObject[];
};
export type Dispatch = {
    navigation: {
        reset: () => void;
    };
    table: {
        updateSelectedColumn: (columnMetadata: TestScenarioSelectedColumnMetaData | null) => void;
    };
};
export declare const defaultStaticState: () => Omit<State, "computed" | "dispatch" | "scesim">;
export declare function createTestScenarioEditorStore(model: SceSimModel, computedCache: ComputedStateCache<Computed>): import("zustand").UseBoundStore<import("zustand/middleware/immer").WithImmer<import("zustand").StoreApi<State>>>;
//# sourceMappingURL=TestScenarioEditorStore.d.ts.map