"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SwfLanguageServiceCodeLenses = void 0;
var channel_1 = require("@kie-tools/json-yaml-language-service/dist/channel");
var logInRegistries = function (args, jsonPath) {
    return !args.displayRhhccIntegration
        ? []
        : (0, channel_1.createCodeLenses)({
            document: args.document,
            rootNode: args.rootNode,
            jsonPath: jsonPath,
            positionLensAt: "begin",
            commandDelegates: function (_a) {
                var position = _a.position, node = _a.node;
                var commandName = "swf.ls.commands.LogInServiceRegistries";
                if (node.type !== "array" ||
                    !args.codeCompletionStrategy.shouldCreateCodelens({ node: node, commandName: commandName, content: args.content }) ||
                    args.config.shouldConfigureServiceRegistries() ||
                    !args.config.shouldServiceRegistriesLogIn()) {
                    return [];
                }
                return [
                    {
                        name: commandName,
                        title: "↪ Log in Service Registries...",
                        args: [{ position: position }],
                    },
                ];
            },
        });
};
var setUpRegistries = function (args, jsonPath) {
    return !args.displayRhhccIntegration
        ? []
        : (0, channel_1.createCodeLenses)({
            document: args.document,
            rootNode: args.rootNode,
            jsonPath: jsonPath,
            positionLensAt: "begin",
            commandDelegates: function (_a) {
                var position = _a.position, node = _a.node;
                var commandName = "swf.ls.commands.OpenServiceRegistriesConfig";
                if (node.type !== "array" ||
                    !args.codeCompletionStrategy.shouldCreateCodelens({ node: node, commandName: commandName, content: args.content }) ||
                    !args.config.shouldConfigureServiceRegistries()) {
                    return [];
                }
                return [
                    {
                        name: commandName,
                        title: "↪ Setup Service Registries...",
                        args: [{ position: position }],
                    },
                ];
            },
        });
};
var refreshRegistries = function (args, jsonPath) {
    return !args.displayRhhccIntegration
        ? []
        : (0, channel_1.createCodeLenses)({
            document: args.document,
            rootNode: args.rootNode,
            jsonPath: jsonPath,
            positionLensAt: "begin",
            commandDelegates: function (_a) {
                var position = _a.position, node = _a.node;
                var commandName = "swf.ls.commands.RefreshServiceRegistries";
                if (node.type !== "array" ||
                    !args.codeCompletionStrategy.shouldCreateCodelens({ node: node, commandName: commandName, content: args.content }) ||
                    args.config.shouldConfigureServiceRegistries() ||
                    !args.config.canRefreshServices()) {
                    return [];
                }
                return [
                    {
                        name: commandName,
                        title: "↺ Refresh Service Registries...",
                        args: [{ position: position }],
                    },
                ];
            },
        });
};
exports.SwfLanguageServiceCodeLenses = {
    createNewFile: function () { return (0, channel_1.createNewFileCodeLens)("Create a Serverless Workflow"); },
    addFunction: function (args) {
        return (0, channel_1.createOpenCompletionItemsCodeLenses)(__assign(__assign({}, args), { jsonPath: ["functions"], title: "+ Add function...", nodeType: "array" }));
    },
    addEvent: function (args) {
        return (0, channel_1.createOpenCompletionItemsCodeLenses)(__assign(__assign({}, args), { jsonPath: ["events"], title: "+ Add event...", nodeType: "array" }));
    },
    addState: function (args) {
        return (0, channel_1.createOpenCompletionItemsCodeLenses)(__assign(__assign({}, args), { jsonPath: ["states"], title: "+ Add state...", nodeType: "array" }));
    },
    setupServiceRegistriesForFunctions: function (args) {
        return setUpRegistries(args, ["functions"]);
    },
    logInServiceRegistriesForFunctions: function (args) {
        return logInRegistries(args, ["functions"]);
    },
    refreshServiceRegistriesForFunctions: function (args) {
        return refreshRegistries(args, ["functions"]);
    },
    setupServiceRegistriesForEvents: function (args) {
        return setUpRegistries(args, ["events"]);
    },
    logInServiceRegistriesForEvents: function (args) {
        return logInRegistries(args, ["events"]);
    },
    refreshServiceRegistriesForEvents: function (args) {
        return refreshRegistries(args, ["events"]);
    },
};
//# sourceMappingURL=SwfLanguageServiceCodeLenses.js.map