import { jsx as _jsx } from "react/jsx-runtime";
import React, { useCallback } from "react";
import { RefForwardingEmbeddedEnvelope } from "@kie-tools-core/envelope/dist/embedded";
import { FormsListChannelApiImpl } from "./FormsListChannelApiImpl";
import { ContainerType } from "@kie-tools-core/envelope/dist/api";
import { init } from "../envelope";
export const EmbeddedFormsList = React.forwardRef((props, forwardedRef) => {
    const refDelegate = useCallback((envelopeServer) => ({}), []);
    const pollInit = useCallback((envelopeServer, container) => {
        init({
            config: {
                containerType: ContainerType.DIV,
                envelopeId: envelopeServer.id,
            },
            container: container(),
            bus: {
                postMessage(message, targetOrigin, transfer) {
                    window.postMessage(message, targetOrigin, transfer);
                },
            },
        });
        return envelopeServer.envelopeApi.requests.formsList__init({
            origin: envelopeServer.origin,
            envelopeServerId: envelopeServer.id,
        });
    }, []);
    return (_jsx(EmbeddedFormsListEnvelope, { ref: forwardedRef, apiImpl: new FormsListChannelApiImpl(props.driver), origin: props.targetOrigin, refDelegate: refDelegate, pollInit: pollInit, config: { containerType: ContainerType.DIV } }));
});
const EmbeddedFormsListEnvelope = React.forwardRef(RefForwardingEmbeddedEnvelope);
//# sourceMappingURL=EmbeddedFormsList.js.map