import { BulkProcessInstanceActionResponse, ProcessInstance, ProcessInstanceFilter, ProcessListSortBy } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
import { OperationType } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
export interface ProcessListDriver {
    initialLoad(filter: ProcessInstanceFilter, sortBy: ProcessListSortBy): Promise<void>;
    openProcess(process: ProcessInstance): Promise<void>;
    applyFilter(filter: ProcessInstanceFilter): Promise<void>;
    applySorting(sortBy: ProcessListSortBy): Promise<void>;
    handleProcessSkip(processInstance: ProcessInstance): Promise<void>;
    handleProcessRetry(processInstance: ProcessInstance): Promise<void>;
    handleProcessAbort(processInstance: ProcessInstance): Promise<void>;
    handleProcessMultipleAction(processInstances: ProcessInstance[], operationType: OperationType): Promise<BulkProcessInstanceActionResponse>;
    query(offset: number, limit: number): Promise<ProcessInstance[]>;
    getChildProcessesQuery(rootProcessInstanceId: string): Promise<ProcessInstance[]>;
}
//# sourceMappingURL=ProcessListDriver.d.ts.map