import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import { useImperativeHandle, useState } from "react";
import "@patternfly/patternfly/patternfly.css";
import TaskDetails from "./components/TaskDetails";
export const TaskDetailsEnvelopeView = React.forwardRef((props, forwardedRef) => {
    const [task, setTask] = useState();
    useImperativeHandle(forwardedRef, () => {
        return {
            setTask: (userTask) => {
                setTask(userTask);
            },
        };
    }, []);
    return _jsx(TaskDetails, { userTask: task });
});
//# sourceMappingURL=TaskDetailsEnvelopeView.js.map