import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useEffect, useMemo, useState } from "react";
import { GenericSelector } from "../atoms";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { Stack, StackItem } from "@patternfly/react-core/dist/js/layouts/Stack";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { Form, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { PageSection, PageSectionVariants } from "@patternfly/react-core/dist/js/components/Page";
import { Level, LevelItem } from "@patternfly/react-core/dist/js/layouts/Level";
import { Switch } from "@patternfly/react-core/dist/js/components/Switch";
import "./CorePropertiesTable.scss";
import { Operation } from "../Operation";
import useOnclickOutside from "react-cool-onclickoutside";
import { isEqual } from "lodash";
import { useOperation } from "../OperationContext";
import { useValidationRegistry } from "../../../validation";
import { Builder } from "../../../paths";
import { HelpIcon } from "@patternfly/react-icons/dist/js/icons/help-icon";
import { ValidationIndicatorLabel } from "../../EditorCore/atoms";
var set = Reflect.set;
var get = Reflect.get;
const GenericSelectorEditor = (id, items, selection, onSelect, isDisabled) => {
    return _jsx(GenericSelector, { id: id, items: items, selection: selection, onSelect: onSelect, isDisabled: isDisabled });
};
export const CorePropertiesTable = (props) => {
    const { activeOperation, setActiveOperation } = useOperation();
    const [isEditing, setEditing] = useState(false);
    const [isScorable, setScorable] = useState();
    const [functionName, setFunctionName] = useState();
    const [algorithmName, setAlgorithmName] = useState();
    const [baselineScore, setBaselineScore] = useState();
    const [baselineMethod, setBaselineMethod] = useState();
    const [initialScore, setInitialScore] = useState();
    const [areReasonCodesUsed, setAreReasonCodesUsed] = useState();
    const [reasonCodeAlgorithm, setReasonCodeAlgorithm] = useState();
    useEffect(() => {
        setScorable(props.isScorable);
        setFunctionName(props.functionName);
        setAlgorithmName(props.algorithmName);
        setBaselineScore(props.baselineScore);
        setBaselineMethod(props.baselineMethod);
        setInitialScore(props.initialScore);
        setAreReasonCodesUsed(props.areReasonCodesUsed);
        setReasonCodeAlgorithm(props.reasonCodeAlgorithm);
    }, [props]);
    const ref = useOnclickOutside(() => onCommitAndClose(), {
        disabled: activeOperation !== Operation.UPDATE_CORE,
        eventTypes: ["click"],
    });
    const toNumber = (_value) => {
        if (_value === "") {
            return undefined;
        }
        const n = Number(_value);
        if (isNaN(n)) {
            return undefined;
        }
        return n;
    };
    const toYesNo = (_value) => {
        return _value ? "Yes" : "No";
    };
    const onEdit = (event) => {
        event.preventDefault();
        event.stopPropagation();
        setActiveOperation(Operation.UPDATE_CORE);
        setEditing(true);
    };
    const onCommitAndClose = () => {
        onCommit({});
        onCancel();
    };
    const onCommit = (partial) => {
        const existingPartial = {};
        Object.keys(partial).forEach((key) => set(existingPartial, key, get(props, key)));
        if (!isEqual(partial, existingPartial)) {
            props.commit({ ...props, ...partial });
        }
    };
    const onCancel = () => {
        setEditing(false);
        setActiveOperation(Operation.NONE);
    };
    const isEditModeEnabled = useMemo(() => isEditing && activeOperation === Operation.UPDATE_CORE, [isEditing, activeOperation]);
    const { validationRegistry } = useValidationRegistry();
    const baselineScoreValidation = validationRegistry.get(Builder().forModel(props.modelIndex).forBaselineScore().build());
    return (_jsxs(_Fragment, { children: [!isEditModeEnabled && (_jsx("div", { tabIndex: 0, onClick: onEdit, onKeyDown: (e) => {
                    if (e.key === "Enter") {
                        onEdit(e);
                    }
                }, "data-testid": "core-properties-table", children: _jsx(PageSection, { variant: PageSectionVariants.light, className: "editable-item", "data-ouia-component-type": "model-setup-overview", children: _jsx(Stack, { hasGutter: true, children: _jsx(StackItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(Title, { size: "lg", headingLevel: "h1", children: "Model Setup" }) }), _jsxs(SplitItem, { children: [isScorable !== undefined && CorePropertyLabel("Is Scorable", toYesNo(isScorable)), functionName !== undefined && CorePropertyLabel("Function", functionName), algorithmName !== undefined && CorePropertyLabel("Algorithm", algorithmName), initialScore !== undefined && CorePropertyLabel("Initial Score", initialScore), areReasonCodesUsed !== undefined &&
                                                CorePropertyLabel("Use Reason Codes", toYesNo(areReasonCodesUsed)), reasonCodeAlgorithm !== undefined &&
                                                CorePropertyLabel("Reason Code Algorithm", reasonCodeAlgorithm), baselineScore !== undefined &&
                                                baselineScoreValidation.length === 0 &&
                                                CorePropertyLabel("Baseline Score", baselineScore), baselineScoreValidation.length > 0 && (_jsx(ValidationIndicatorLabel, { validations: baselineScoreValidation, cssClass: "core-properties__label", children: _jsxs(_Fragment, { children: [_jsx("strong", { children: "Baseline Score:" }), "\u00A0", _jsx("em", { children: "Missing" })] }) })), baselineMethod !== undefined && CorePropertyLabel("Baseline Method", baselineMethod)] })] }) }) }) }) })), isEditModeEnabled && (_jsx("div", { ref: ref, "data-testid": "core-properties-table", children: _jsx(PageSection, { variant: PageSectionVariants.light, className: "editable-item--editing", "data-ouia-component-type": "edit-model-setup", children: _jsxs(Stack, { hasGutter: true, children: [_jsx(StackItem, { children: _jsx(Split, { hasGutter: true, children: _jsx(SplitItem, { children: _jsx(Title, { size: "lg", headingLevel: "h1", children: "Model Setup" }) }) }) }), _jsx(StackItem, { children: _jsx(Form, { onSubmit: (e) => {
                                        e.stopPropagation();
                                        e.preventDefault();
                                    }, className: "core-properties__container", children: _jsxs(Level, { hasGutter: true, children: [_jsx(LevelItem, { children: _jsx(FormGroup, { label: "Is Scorable", fieldId: "core-isScorable", children: _jsx(Switch, { id: "core-isScorable", isChecked: isScorable === true, "aria-label": "Is scorable", "data-testid": "core-properties-table-isScorable", onChange: (checked) => {
                                                            setScorable(checked);
                                                            onCommit({ isScorable: checked });
                                                        }, ouiaId: "is-scorable" }) }) }), _jsx(LevelItem, { children: _jsx(FormGroup, { label: "Function", fieldId: "core-functionName", required: true, children: GenericSelectorEditor("core-functionName", [
                                                        "associationRules",
                                                        "sequences",
                                                        "classification",
                                                        "regression",
                                                        "clustering",
                                                        "timeSeries",
                                                        "mixed",
                                                    ], functionName, (_selection) => {
                                                        setFunctionName(_selection);
                                                        onCommit({ functionName: _selection });
                                                    }, true) }) }), _jsx(LevelItem, { children: _jsx(FormGroup, { label: "Algorithm", fieldId: "core-algorithmName", children: _jsx(TextInput, { type: "text", id: "core-algorithmName", name: "core-algorithmName", "aria-describedby": "core-algorithmName", "data-testid": "core-properties-table-algorithmName", value: algorithmName !== null && algorithmName !== void 0 ? algorithmName : "", onChange: (e) => setAlgorithmName(e), onBlur: () => {
                                                            onCommit({
                                                                algorithmName: algorithmName === "" ? undefined : algorithmName,
                                                            });
                                                        }, ouiaId: "algorithm" }) }) }), _jsx(LevelItem, { children: _jsx(FormGroup, { label: "Initial score", fieldId: "core-initialScore", children: _jsx(TextInput, { id: "core-initialScore", value: initialScore, onChange: (e) => setInitialScore(toNumber(e)), onBlur: () => {
                                                            onCommit({ initialScore: initialScore });
                                                        }, type: "number", ouiaId: "initial-score" }) }) }), _jsx(LevelItem, { children: _jsx(FormGroup, { label: "Use reason codes?", fieldId: "core-useReasonCodes", children: _jsx(Switch, { id: "core-useReasonCodes", isChecked: areReasonCodesUsed, "aria-label": "Use reason codes", "data-testid": "core-properties-table-useReasonCodes", onChange: (checked) => {
                                                            setAreReasonCodesUsed(checked);
                                                            onCommit({ areReasonCodesUsed: checked });
                                                        }, ouiaId: "use-reason-codes" }) }) }), _jsx(LevelItem, { children: _jsx(FormGroup, { label: "Reason code algorithm", fieldId: "core-reasonCodeAlgorithm", children: GenericSelectorEditor("core-reasonCodeAlgorithm", ["pointsAbove", "pointsBelow"], reasonCodeAlgorithm, (_selection) => {
                                                        setReasonCodeAlgorithm(_selection);
                                                        onCommit({ reasonCodeAlgorithm: _selection });
                                                    }, !areReasonCodesUsed) }) }), _jsx(LevelItem, { children: _jsx(FormGroup, { label: "Baseline score", fieldId: "core-baselineScore", validated: baselineScoreValidation.length > 0 ? "warning" : "default", helperText: baselineScoreValidation.length > 0 ? baselineScoreValidation[0].message : undefined, labelIcon: _jsx(Tooltip, { content: areReasonCodesUsed && props.isBaselineScoreDisabled
                                                            ? `A Baseline score is already provided inside all Characteristics`
                                                            : `
                                When Use Reason Codes is set to yes, a Baseline score value must be provided. \
                                Alternatively you can provide a Baseline score for all the characteristics
                                `, children: _jsx("button", { "aria-label": "More information for Baseline score", onClick: (e) => e.preventDefault(), className: "pf-c-form__group-label-help", children: _jsx(HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) }) }), children: _jsx(TextInput, { id: "core-baselineScore", value: baselineScore !== null && baselineScore !== void 0 ? baselineScore : "", onChange: (e) => setBaselineScore(toNumber(e)), onBlur: () => {
                                                            onCommit({ baselineScore: baselineScore });
                                                        }, type: "number", validated: baselineScoreValidation.length > 0 ? "warning" : "default", isDisabled: props.isBaselineScoreDisabled, ouiaId: "baseline-score" }) }) }), _jsx(LevelItem, { children: _jsx(FormGroup, { label: "Baseline method", fieldId: "core-baselineMethod", children: GenericSelectorEditor("core-baselineMethod", ["max", "min", "mean", "neutral", "other"], baselineMethod, (_selection) => {
                                                        setBaselineMethod(_selection);
                                                        onCommit({ baselineMethod: _selection });
                                                    }, !areReasonCodesUsed) }) })] }) }) })] }) }) }))] }));
};
const CorePropertyLabel = (name, value) => {
    return (_jsxs(Label, { color: "cyan", className: "core-properties__label", "data-ouia-component-type": "model-property", children: [_jsxs("strong", { children: [name, ":"] }), "\u00A0", _jsx("span", { children: value })] }));
};
//# sourceMappingURL=CorePropertiesTable.js.map