import { BulkWorkflowInstanceActionResponse, WorkflowInstance, WorkflowInstanceFilter, WorkflowListSortBy } from "@kie-tools/runtime-tools-swf-gateway-api/dist/types";
import { WorkflowListQueries } from "./WorkflowListQueries";
import { OperationType } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
export interface WorkflowListGatewayApi {
    workflowListState: WorkflowListState;
    initialLoad: (filter: WorkflowInstanceFilter, sortBy: WorkflowListSortBy) => Promise<void>;
    openWorkflow: (workflow: WorkflowInstance) => Promise<void>;
    applyFilter: (filter: WorkflowInstanceFilter) => Promise<void>;
    applySorting: (SortBy: WorkflowListSortBy) => Promise<void>;
    handleWorkflowSkip: (workflowInstance: WorkflowInstance) => Promise<void>;
    handleWorkflowRetry: (workflowInstance: WorkflowInstance) => Promise<void>;
    handleWorkflowAbort: (workflowInstance: WorkflowInstance) => Promise<void>;
    handleWorkflowMultipleAction: (workflowInstances: WorkflowInstance[], operationType: OperationType) => Promise<BulkWorkflowInstanceActionResponse>;
    query(offset: number, limit: number): Promise<WorkflowInstance[]>;
    getChildWorkflowsQuery(rootWorkflowInstanceId: string): Promise<WorkflowInstance[]>;
    openTriggerCloudEvent: (workflowInstance?: WorkflowInstance) => void;
    onOpenWorkflowListen: (listener: OnOpenWorkflowListener) => UnSubscribeHandler;
    onOpenTriggerCloudEventListen: (listener: OnOpenTriggerCloudEventListener) => UnSubscribeHandler;
}
export interface WorkflowListState {
    filters: WorkflowInstanceFilter;
    sortBy: WorkflowListSortBy;
}
export interface OnOpenWorkflowListener {
    onOpen: (workflow: WorkflowInstance) => void;
}
export interface OnOpenTriggerCloudEventListener {
    onOpen: (workflow?: WorkflowInstance) => void;
}
export interface UnSubscribeHandler {
    unSubscribe: () => void;
}
export declare class WorkflowListGatewayApiImpl implements WorkflowListGatewayApi {
    private readonly onOpenWorkflowListeners;
    private readonly onOpenTriggerCloudEventListeners;
    private readonly queries;
    private _WorkflowListState;
    constructor(queries: WorkflowListQueries);
    get workflowListState(): WorkflowListState;
    openWorkflow: (workflow: WorkflowInstance) => Promise<void>;
    initialLoad: (filter: WorkflowInstanceFilter, sortBy: WorkflowListSortBy) => Promise<void>;
    applyFilter: (filter: WorkflowInstanceFilter) => Promise<void>;
    applySorting: (sortBy: WorkflowListSortBy) => Promise<void>;
    handleWorkflowSkip: (workflowInstance: WorkflowInstance) => Promise<void>;
    handleWorkflowRetry: (workflowInstance: WorkflowInstance) => Promise<void>;
    handleWorkflowAbort: (workflowInstance: WorkflowInstance) => Promise<void>;
    handleWorkflowMultipleAction: (workflowInstances: WorkflowInstance[], operationType: OperationType) => Promise<BulkWorkflowInstanceActionResponse>;
    query(offset: number, limit: number): Promise<WorkflowInstance[]>;
    getChildWorkflowsQuery(rootWorkflowInstanceId: string): Promise<WorkflowInstance[]>;
    onOpenWorkflowListen(listener: OnOpenWorkflowListener): UnSubscribeHandler;
    onOpenTriggerCloudEventListen(listener: OnOpenTriggerCloudEventListener): UnSubscribeHandler;
    openTriggerCloudEvent(workflowInstance?: WorkflowInstance): void;
}
//# sourceMappingURL=WorkflowListGatewayApi.d.ts.map