/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.extension.auth.opa.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.polaris.extension.auth.opa.model.Actor;
import org.immutables.value.Generated;

@Generated(from="Actor", generator="Immutables")
public final class ImmutableActor
implements Actor {
    private final String principal;
    private final ImmutableList<String> roles;
    private transient int hashCode;

    private ImmutableActor(String principal, ImmutableList<String> roles) {
        this.principal = principal;
        this.roles = roles;
    }

    @Override
    @JsonProperty(required=true)
    public String principal() {
        return this.principal;
    }

    @JsonProperty
    public ImmutableList<String> roles() {
        return this.roles;
    }

    public final ImmutableActor withPrincipal(String value) {
        String newValue = Objects.requireNonNull(value, "principal");
        if (this.principal.equals(newValue)) {
            return this;
        }
        return new ImmutableActor(newValue, this.roles);
    }

    public final ImmutableActor withRoles(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableActor(this.principal, (ImmutableList<String>)newValue);
    }

    public final ImmutableActor withRoles(Iterable<String> elements) {
        if (this.roles == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableActor(this.principal, (ImmutableList<String>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableActor && this.equalsByValue((ImmutableActor)another);
    }

    private boolean equalsByValue(ImmutableActor another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.principal.equals(another.principal) && this.roles.equals(another.roles);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.principal.hashCode();
        h += (h << 5) + this.roles.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Actor").omitNullValues().add("principal", (Object)this.principal).add("roles", this.roles).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableActor fromJson(Json json) {
        Builder builder = ImmutableActor.builder();
        if (json._principal != null) {
            builder.principal(json._principal);
        }
        if (json._roles != null) {
            builder.addAllRoles(json._roles);
        }
        return builder.build();
    }

    public static ImmutableActor copyOf(Actor instance) {
        if (instance instanceof ImmutableActor) {
            return (ImmutableActor)instance;
        }
        return ImmutableActor.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableActor.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Actor", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PRINCIPAL = 1L;
        private long initBits = 1L;
        private String principal;
        private ImmutableList.Builder<String> roles = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Actor instance) {
            Objects.requireNonNull(instance, "instance");
            this.principal(instance.principal());
            this.addAllRoles(instance.roles());
            return this;
        }

        @JsonProperty(required=true)
        @CanIgnoreReturnValue
        public final Builder principal(String principal) {
            this.principal = Objects.requireNonNull(principal, "principal");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRole(String element) {
            this.roles.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRoles(String ... elements) {
            this.roles.add((Object[])elements);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder roles(Iterable<String> elements) {
            this.roles = ImmutableList.builder();
            return this.addAllRoles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRoles(Iterable<String> elements) {
            this.roles.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.initBits = 1L;
            this.principal = null;
            this.roles = ImmutableList.builder();
            return this;
        }

        public ImmutableActor build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableActor(this.principal, (ImmutableList<String>)this.roles.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("principal");
            }
            return "Cannot build Actor, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="Actor", generator="Immutables")
    static final class Json
    implements Actor {
        @JsonIgnore
        String _principal;
        @JsonIgnore
        List<String> _roles = ImmutableList.of();

        Json() {
        }

        @JsonProperty(required=true)
        public void setPrincipal(String principal) {
            this._principal = principal;
        }

        @JsonProperty
        public void setRoles(List<String> roles) {
            this._roles = roles;
        }

        @Override
        public String principal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> roles() {
            throw new UnsupportedOperationException();
        }
    }
}

