/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage.cache;

import jakarta.annotation.Nullable;
import java.util.Optional;
import java.util.Set;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.core.storage.cache.ImmutableStorageCredentialCacheKey;
import org.apache.polaris.immutables.PolarisImmutable;
import org.immutables.value.Value;

@PolarisImmutable
public interface StorageCredentialCacheKey {
    @Value.Parameter(order=1)
    public String realmId();

    @Value.Parameter(order=2)
    public long catalogId();

    @Nullable
    @Value.Parameter(order=3)
    public String storageConfigSerializedStr();

    @Value.Parameter(order=4)
    public boolean allowedListAction();

    @Value.Parameter(order=5)
    public Set<String> allowedReadLocations();

    @Value.Parameter(order=6)
    public Set<String> allowedWriteLocations();

    @Value.Parameter(order=7)
    public Optional<String> refreshCredentialsEndpoint();

    public static StorageCredentialCacheKey of(String realmId, PolarisEntity entity, boolean allowedListAction, Set<String> allowedReadLocations, Set<String> allowedWriteLocations, Optional<String> refreshCredentialsEndpoint) {
        String storageConfigSerializedStr = entity.getInternalPropertiesAsMap().get(PolarisEntityConstants.getStorageConfigInfoPropertyName());
        return ImmutableStorageCredentialCacheKey.of(realmId, entity.getCatalogId(), storageConfigSerializedStr, allowedListAction, allowedReadLocations, allowedWriteLocations, refreshCredentialsEndpoint);
    }
}

