/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime;

import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.CertificateAuthenticationRequest;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.smallrye.mutiny.Uni;
import jakarta.inject.Singleton;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.function.Function;

@Singleton
public class X509IdentityProvider
implements IdentityProvider<CertificateAuthenticationRequest> {
    private static final String ROLES_MAPPER_ATTRIBUTE = "roles_mapper";

    public Class<CertificateAuthenticationRequest> getRequestType() {
        return CertificateAuthenticationRequest.class;
    }

    public Uni<SecurityIdentity> authenticate(CertificateAuthenticationRequest request, AuthenticationRequestContext context) {
        X509Certificate certificate = request.getCertificate().getCertificate();
        return Uni.createFrom().item((Object)QuarkusSecurityIdentity.builder().setPrincipal(certificate.getSubjectX500Principal()).addCredential((Credential)request.getCertificate()).addRoles(X509IdentityProvider.extractRoles(certificate, (Function)request.getAttribute(ROLES_MAPPER_ATTRIBUTE))).build());
    }

    private static Set<String> extractRoles(X509Certificate certificate, Function<X509Certificate, Set<String>> certificateToRoles) {
        return certificateToRoles == null ? Set.of() : certificateToRoles.apply(certificate);
    }
}

