/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.doublelive;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import org.apache.iotdb.db.doublelive.OperationSyncLogService;
import org.apache.iotdb.db.doublelive.OperationSyncPlanTypeUtils;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationSyncProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationSyncProducer.class);
    private final ArrayList<BlockingQueue<Pair<ByteBuffer, OperationSyncPlanTypeUtils.OperationSyncPlanType>>> operationSyncQueues;
    private final OperationSyncLogService dmlLogService;

    public OperationSyncProducer(ArrayList<BlockingQueue<Pair<ByteBuffer, OperationSyncPlanTypeUtils.OperationSyncPlanType>>> operationSyncQueue, OperationSyncLogService operationSyncDMLLogService) {
        this.operationSyncQueues = operationSyncQueue;
        this.dmlLogService = operationSyncDMLLogService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Pair<ByteBuffer, OperationSyncPlanTypeUtils.OperationSyncPlanType> planPair, String deviceName) {
        int index;
        ByteBuffer headBuffer = (ByteBuffer)planPair.left;
        headBuffer.position(0);
        if (deviceName == null) {
            index = this.operationSyncQueues.size() - 1;
        } else {
            try {
                index = Math.abs(deviceName.hashCode()) % (this.operationSyncQueues.size() - 1);
            }
            catch (Exception e) {
                index = 0;
            }
        }
        if (this.operationSyncQueues.get(index).offer(planPair)) {
            return;
        }
        try {
            headBuffer.position(headBuffer.limit());
            this.dmlLogService.acquireLogWriter();
            this.dmlLogService.write(headBuffer);
        }
        catch (IOException e) {
            LOGGER.error("OperationSyncConsumer can't serialize physicalPlan", (Throwable)e);
        }
        finally {
            this.dmlLogService.releaseLogWriter();
        }
    }
}

