/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.task.subtask.processor;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.concurrent.WrappedRunnable;
import org.apache.iotdb.db.pipe.agent.task.subtask.processor.PipeProcessorSubtask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeProcessorSubtaskWorker
extends WrappedRunnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeProcessorSubtaskWorker.class);
    private static final int SLEEP_INTERVAL_ADJUSTMENT_ROUND_INTERVAL = 100;
    private int totalRoundInAdjustmentInterval = 0;
    private int workingRoundInAdjustmentInterval = 0;
    private long sleepingTimeInMilliSecond = 50L;
    private final Set<PipeProcessorSubtask> subtasks = Collections.newSetFromMap(new ConcurrentHashMap());

    public void runMayThrow() {
        while (true) {
            this.cleanupClosedSubtasksIfNecessary();
            boolean canSleepBeforeNextRound = this.runSubtasks();
            this.sleepIfNecessary(canSleepBeforeNextRound);
            this.adjustSleepingTimeIfNecessary();
        }
    }

    private void cleanupClosedSubtasksIfNecessary() {
        this.subtasks.removeIf(PipeProcessorSubtask::isClosed);
    }

    private boolean runSubtasks() {
        ++this.totalRoundInAdjustmentInterval;
        boolean canSleepBeforeNextRound = true;
        for (PipeProcessorSubtask subtask : this.subtasks) {
            if (subtask.isClosed() || !subtask.isSubmittingSelf() || subtask.isStoppedByException()) continue;
            try {
                boolean hasAtLeastOneEventProcessed = subtask.call();
                if (hasAtLeastOneEventProcessed) {
                    canSleepBeforeNextRound = false;
                }
                subtask.onSuccess(hasAtLeastOneEventProcessed);
            }
            catch (Exception e) {
                if (subtask.isClosed()) {
                    LOGGER.warn("subtask {} is closed, ignore exception", (Object)subtask, (Object)e);
                    continue;
                }
                subtask.onFailure(e);
            }
        }
        return canSleepBeforeNextRound;
    }

    private void sleepIfNecessary(boolean canSleepBeforeNextRound) {
        if (canSleepBeforeNextRound) {
            try {
                Thread.sleep(this.sleepingTimeInMilliSecond);
            }
            catch (InterruptedException e) {
                LOGGER.warn("subtask worker is interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        } else {
            ++this.workingRoundInAdjustmentInterval;
        }
    }

    private void adjustSleepingTimeIfNecessary() {
        if (this.totalRoundInAdjustmentInterval % 100 == 0) {
            double workingRatioInAdjustmentInterval = (double)this.workingRoundInAdjustmentInterval / (double)this.totalRoundInAdjustmentInterval;
            if (0.25 <= workingRatioInAdjustmentInterval) {
                this.sleepingTimeInMilliSecond = Math.max(1L, this.sleepingTimeInMilliSecond / 2L);
            }
            if (workingRatioInAdjustmentInterval <= 0.05) {
                this.sleepingTimeInMilliSecond = Math.min(1000L, this.sleepingTimeInMilliSecond * 2L);
            }
            this.totalRoundInAdjustmentInterval = 0;
            this.workingRoundInAdjustmentInterval = 0;
        }
    }

    public void schedule(PipeProcessorSubtask pipeProcessorSubtask) {
        this.subtasks.add(pipeProcessorSubtask);
    }
}

