/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.metric;

import org.apache.iotdb.commons.pipe.config.PipeConfig;

public abstract class PipeRemainingOperator {
    protected static final long REMAINING_MAX_SECONDS = 31536000L;
    protected String pipeName;
    protected long creationTime = 0L;
    private long lastEmptyTimeStamp = System.currentTimeMillis();
    private long lastNonEmptyTimeStamp = System.currentTimeMillis();
    protected boolean isStopped = true;

    protected PipeRemainingOperator(String pipeName, long creationTime) {
        this.pipeName = pipeName;
        this.creationTime = creationTime;
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    protected void notifyNonEmpty() {
        long pipeRemainingTimeCommitAutoSwitchSeconds = PipeConfig.getInstance().getPipeRemainingTimeCommitAutoSwitchSeconds();
        this.lastNonEmptyTimeStamp = System.currentTimeMillis();
        if (this.lastNonEmptyTimeStamp - this.lastEmptyTimeStamp >= pipeRemainingTimeCommitAutoSwitchSeconds * 1000L) {
            this.thawRate(false);
        }
    }

    protected void notifyEmpty() {
        long pipeRemainingTimeCommitAutoSwitchSeconds = PipeConfig.getInstance().getPipeRemainingTimeCommitAutoSwitchSeconds();
        this.lastEmptyTimeStamp = System.currentTimeMillis();
        if (this.lastEmptyTimeStamp - this.lastNonEmptyTimeStamp >= pipeRemainingTimeCommitAutoSwitchSeconds * 1000L) {
            this.freezeRate(false);
        }
    }

    public synchronized void thawRate(boolean isStartPipe) {
        if (isStartPipe) {
            this.isStopped = false;
        }
    }

    public synchronized void freezeRate(boolean isStopPipe) {
        if (isStopPipe) {
            this.isStopped = true;
        }
    }
}

