/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SubscriptionStatement;

public class DropTopic
extends SubscriptionStatement {
    private final String topicName;
    private final boolean ifExistsCondition;

    public DropTopic(String topicName, boolean ifExistsCondition) {
        this.topicName = Objects.requireNonNull(topicName, "topic name can not be null");
        this.ifExistsCondition = ifExistsCondition;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public boolean hasIfExistsCondition() {
        return this.ifExistsCondition;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropTopic(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.topicName, this.ifExistsCondition);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DropTopic that = (DropTopic)obj;
        return Objects.equals(this.topicName, that.topicName) && Objects.equals(this.ifExistsCondition, that.ifExistsCondition);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("topicName", (Object)this.topicName).add("ifExistsCondition", this.ifExistsCondition).toString();
    }
}

