/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.db.protocol.thrift.handler.RPCServiceThriftHandlerMetrics;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.compress.IUnCompressor;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TabletDecoder {
    private final CompressionType compressionType;
    private final TSDataType[] dataTypes;
    private final List<TSEncoding> columnEncodings;
    private final IUnCompressor unCompressor;
    private final int rowSize;

    public TabletDecoder(CompressionType compressionType, TSDataType[] dataTypes, List<TSEncoding> columnEncodings, int rowSize) {
        this.compressionType = compressionType;
        this.dataTypes = dataTypes;
        this.columnEncodings = columnEncodings;
        this.unCompressor = IUnCompressor.getUnCompressor((CompressionType)compressionType);
        this.rowSize = rowSize;
    }

    public long[] decodeTime(ByteBuffer buffer) {
        int compressedSize = buffer.remaining();
        ByteBuffer uncompressedBuffer = this.uncompress(buffer);
        RPCServiceThriftHandlerMetrics.getInstance().recordUnCompressionSizeTimer(uncompressedBuffer.remaining());
        RPCServiceThriftHandlerMetrics.getInstance().recordCompressionSizeTimer(compressedSize);
        long memoryUsage = this.compressionType == CompressionType.UNCOMPRESSED ? (long)uncompressedBuffer.remaining() : (long)(uncompressedBuffer.remaining() + compressedSize);
        RPCServiceThriftHandlerMetrics.getInstance().recordMemoryUsage(memoryUsage);
        long startDecodeTime = System.nanoTime();
        long[] timeStamps = this.decodeColumnForTimeStamp(uncompressedBuffer, this.rowSize);
        RPCServiceThriftHandlerMetrics.getInstance().recordDecodeLatencyTimer(System.nanoTime() - startDecodeTime);
        return timeStamps;
    }

    private ByteBuffer uncompress(ByteBuffer compressedBuffer) {
        long startUncompressTime = System.nanoTime();
        if (this.compressionType == CompressionType.UNCOMPRESSED) {
            return compressedBuffer;
        }
        try {
            int uncompressedLength = compressedBuffer.getInt(compressedBuffer.limit() - 4);
            byte[] uncompressedBytes = new byte[uncompressedLength];
            this.unCompressor.uncompress(compressedBuffer.array(), compressedBuffer.arrayOffset() + compressedBuffer.position(), compressedBuffer.remaining() - 4, uncompressedBytes, 0);
            ByteBuffer output = ByteBuffer.wrap(uncompressedBytes);
            RPCServiceThriftHandlerMetrics.getInstance().recordDecompressLatencyTimer(System.nanoTime() - startUncompressTime);
            return output;
        }
        catch (IOException e) {
            throw new IoTDBRuntimeException("Failed to decompress compressedBuffer", (Throwable)e, TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }

    private long[] decodeColumnForTimeStamp(ByteBuffer buffer, int rowCount) {
        TSDataType dataType = TSDataType.INT64;
        TSEncoding encodingType = this.columnEncodings.get(0);
        Decoder decoder = Decoder.getDecoderByType((TSEncoding)encodingType, (TSDataType)dataType);
        long[] result = new long[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            result[i] = decoder.readLong(buffer);
        }
        return result;
    }

    public Pair<Object[], ByteBuffer> decodeValues(ByteBuffer buffer) {
        int compressedSize = buffer.remaining();
        ByteBuffer uncompressed = this.uncompress(buffer);
        RPCServiceThriftHandlerMetrics.getInstance().recordUnCompressionSizeTimer(uncompressed.remaining());
        RPCServiceThriftHandlerMetrics.getInstance().recordCompressionSizeTimer(compressedSize);
        long startDecodeTime = System.nanoTime();
        Object[] columns = new Object[this.dataTypes.length];
        for (int i = 0; i < this.dataTypes.length; ++i) {
            columns[i] = this.decodeColumn(uncompressed, i);
        }
        RPCServiceThriftHandlerMetrics.getInstance().recordDecodeLatencyTimer(System.nanoTime() - startDecodeTime);
        return new Pair((Object)columns, (Object)uncompressed);
    }

    private Object decodeColumn(ByteBuffer uncompressed, int columnIndex) {
        TSDataType dataType = this.dataTypes[columnIndex];
        TSEncoding encoding = this.columnEncodings.get(columnIndex + 1);
        Decoder decoder = Decoder.getDecoderByType((TSEncoding)encoding, (TSDataType)dataType);
        Object[] column = null;
        switch (dataType) {
            case DATE: 
            case INT32: {
                int[] intCol = new int[this.rowSize];
                if (encoding == TSEncoding.PLAIN) {
                    for (int j = 0; j < this.rowSize; ++j) {
                        intCol[j] = ReadWriteIOUtils.readInt((ByteBuffer)uncompressed);
                    }
                } else {
                    for (int j = 0; j < this.rowSize; ++j) {
                        intCol[j] = decoder.readInt(uncompressed);
                    }
                }
                column = intCol;
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                long[] longCol = new long[this.rowSize];
                for (int j = 0; j < this.rowSize; ++j) {
                    longCol[j] = decoder.readLong(uncompressed);
                }
                column = longCol;
                break;
            }
            case FLOAT: {
                float[] floatCol = new float[this.rowSize];
                for (int j = 0; j < this.rowSize; ++j) {
                    floatCol[j] = decoder.readFloat(uncompressed);
                }
                column = floatCol;
                break;
            }
            case DOUBLE: {
                double[] doubleCol = new double[this.rowSize];
                for (int j = 0; j < this.rowSize; ++j) {
                    doubleCol[j] = decoder.readDouble(uncompressed);
                }
                column = doubleCol;
                break;
            }
            case BOOLEAN: {
                boolean[] boolCol = new boolean[this.rowSize];
                for (int j = 0; j < this.rowSize; ++j) {
                    boolCol[j] = decoder.readBoolean(uncompressed);
                }
                column = boolCol;
                break;
            }
            case STRING: 
            case BLOB: 
            case TEXT: {
                Binary[] binaryCol = new Binary[this.rowSize];
                if (encoding == TSEncoding.PLAIN) {
                    for (int j = 0; j < this.rowSize; ++j) {
                        binaryCol[j] = ReadWriteIOUtils.readBinary((ByteBuffer)uncompressed);
                    }
                } else {
                    for (int j = 0; j < this.rowSize; ++j) {
                        binaryCol[j] = decoder.readBinary(uncompressed);
                    }
                }
                column = binaryCol;
                break;
            }
            case UNKNOWN: 
            case VECTOR: {
                throw new IllegalArgumentException("Unsupported data type: " + dataType);
            }
        }
        return column;
    }
}

