/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionQueue {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Object queueLock = new Object();
    private final ArrayDeque<Runnable> queue = new ArrayDeque();
    private int pending = 0;
    private boolean paused = false;
    private final Executor executor;
    private final int concurrencyLimit;

    public ExecutionQueue(Executor executor) {
        this(executor, 1);
    }

    public ExecutionQueue(Executor executor, int concurrencyLimit) {
        this.executor = executor;
        this.concurrencyLimit = concurrencyLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(Runnable runnable) {
        Object object = this.queueLock;
        synchronized (object) {
            this.queue.add(runnable);
            this.maybePollAndExecute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitToHead(Runnable runnable) {
        Object object = this.queueLock;
        synchronized (object) {
            this.queue.addFirst(runnable);
            this.maybePollAndExecute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.queueLock;
        synchronized (object) {
            this.paused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.queueLock;
        synchronized (object) {
            this.paused = false;
            this.maybePollAndExecute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybePollAndExecute() {
        Object object = this.queueLock;
        synchronized (object) {
            if (this.pending < this.concurrencyLimit && !this.paused && !this.queue.isEmpty()) {
                this.executor.execute(new Task(this.queue.poll()));
                ++this.pending;
            }
        }
    }

    private class InlineTask
    implements Runnable {
        private final Runnable runnable;

        InlineTask(Runnable runnable) {
            Preconditions.checkNotNull((Object)runnable);
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Throwable throwable) {
                ExecutionQueue.this.log.warn("Uncaught Throwable during execution.", throwable);
            }
            Object object = ExecutionQueue.this.queueLock;
            synchronized (object) {
                if (ExecutionQueue.this.queue.isEmpty() || ExecutionQueue.this.paused) {
                    ExecutionQueue.this.pending--;
                } else {
                    ExecutionQueue.this.executor.execute(new Task((Runnable)ExecutionQueue.this.queue.poll()));
                }
            }
        }
    }

    private class Task
    implements Runnable {
        private final Runnable runnable;

        Task(Runnable runnable) {
            Preconditions.checkNotNull((Object)runnable);
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Throwable throwable) {
                ExecutionQueue.this.log.warn("Uncaught Throwable during execution.", throwable);
            }
            InlineTask inlineTask = null;
            Object object = ExecutionQueue.this.queueLock;
            synchronized (object) {
                if (ExecutionQueue.this.queue.isEmpty() || ExecutionQueue.this.paused) {
                    ExecutionQueue.this.pending--;
                } else {
                    inlineTask = new InlineTask((Runnable)ExecutionQueue.this.queue.poll());
                }
            }
            if (inlineTask != null) {
                inlineTask.run();
            }
        }
    }
}

