/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Base64;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JSONControlDecodeHelper
implements Serializable {
    @NotNull
    public static final String JSON_FIELD_CONTROL_NAME = "control-name";
    @NotNull
    public static final String JSON_FIELD_CRITICALITY = "criticality";
    @NotNull
    public static final String JSON_FIELD_OID = "oid";
    @NotNull
    public static final String JSON_FIELD_VALUE_BASE64 = "value-base64";
    @NotNull
    public static final String JSON_FIELD_VALUE_JSON = "value-json";
    private static final long serialVersionUID = 5752098418939503096L;
    @Nullable
    private final ASN1OctetString rawValue;
    private final boolean criticality;
    @NotNull
    private final JSONObject controlObject;
    @Nullable
    private final JSONObject valueObject;
    @NotNull
    private final String oid;

    public JSONControlDecodeHelper(@NotNull JSONObject controlObject, boolean throwOnUnrecognizedField, boolean allowValue, boolean requireValue) throws LDAPException {
        List<String> unexpectedFields;
        this.controlObject = controlObject;
        this.oid = controlObject.getFieldAsString(JSON_FIELD_OID);
        if (this.oid == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_JSON_CONTROL_MISSING_OID.get(controlObject.toSingleLineString(), JSON_FIELD_OID));
        }
        Boolean criticalityObject = controlObject.getFieldAsBoolean(JSON_FIELD_CRITICALITY);
        if (criticalityObject == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_JSON_CONTROL_MISSING_CRITICALITY.get(controlObject.toSingleLineString(), JSON_FIELD_OID));
        }
        this.criticality = criticalityObject;
        ASN1OctetString valueOctetString = null;
        this.valueObject = controlObject.getFieldAsObject(JSON_FIELD_VALUE_JSON);
        String valueBase64 = controlObject.getFieldAsString(JSON_FIELD_VALUE_BASE64);
        if (valueBase64 == null) {
            if (this.valueObject == null) {
                if (allowValue && requireValue) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_JSON_CONTROL_MISSING_VALUE.get(controlObject.toSingleLineString(), JSON_FIELD_VALUE_BASE64, JSON_FIELD_VALUE_JSON));
                }
            } else if (!allowValue) {
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_JSON_CONTROL_DISALLOWED_VALUE.get(controlObject.toSingleLineString()));
            }
        } else {
            if (!allowValue) {
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_JSON_CONTROL_DISALLOWED_VALUE.get(controlObject.toSingleLineString()));
            }
            if (this.valueObject != null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_JSON_CONTROL_VALUE_CONFLICT.get(controlObject.toSingleLineString(), JSON_FIELD_VALUE_BASE64, JSON_FIELD_VALUE_JSON));
            }
            try {
                valueOctetString = new ASN1OctetString(Base64.decode(valueBase64));
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_JSON_CONTROL_VALUE_NOT_VALID_BASE64.get(controlObject.toSingleLineString(), JSON_FIELD_VALUE_BASE64), e);
            }
        }
        this.rawValue = valueOctetString;
        if (throwOnUnrecognizedField && !(unexpectedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(controlObject, JSON_FIELD_OID, JSON_FIELD_CONTROL_NAME, JSON_FIELD_CRITICALITY, JSON_FIELD_VALUE_BASE64, JSON_FIELD_VALUE_JSON)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_JSON_CONTROL_UNEXPECTED_FIELD.get(controlObject.toSingleLineString(), unexpectedFields.get(0)));
        }
    }

    @NotNull
    public static List<String> getControlObjectUnexpectedFields(@NotNull JSONObject object, String ... allowedFields) {
        LinkedHashSet<String> allowedFieldSet = new LinkedHashSet<String>(Arrays.asList(allowedFields));
        ArrayList<String> disallowedFields = new ArrayList<String>();
        for (String fieldName : object.getFields().keySet()) {
            if (allowedFieldSet.contains(fieldName)) continue;
            disallowedFields.add(fieldName);
        }
        return Collections.unmodifiableList(disallowedFields);
    }

    @NotNull
    public JSONObject getControlObject() {
        return this.controlObject;
    }

    @NotNull
    public String getOID() {
        return this.oid;
    }

    public boolean getCriticality() {
        return this.criticality;
    }

    @Nullable
    public ASN1OctetString getRawValue() {
        return this.rawValue;
    }

    @Nullable
    public JSONObject getValueObject() {
        return this.valueObject;
    }

    @NotNull
    public String toString() {
        return this.controlObject.toSingleLineString();
    }
}

