/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Date;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.james.jmap.JMAPConfiguration;
import org.apache.james.jmap.api.model.Size$;
import org.apache.james.jmap.core.JmapRfc8621Configuration;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.Properties$;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.core.UTCDate;
import org.apache.james.jmap.json.EmailSetSerializer;
import org.apache.james.jmap.mail.BlobId$;
import org.apache.james.jmap.mail.EmailCreationId;
import org.apache.james.jmap.mail.EmailCreationRequest;
import org.apache.james.jmap.mail.EmailCreationResponse;
import org.apache.james.jmap.mail.EmailSetRequest;
import org.apache.james.jmap.mail.ThreadId$;
import org.apache.james.jmap.method.EmailSetCreatePerformer$CreationResults$;
import org.apache.james.jmap.method.SizeExceededException;
import org.apache.james.jmap.routes.BlobNotFoundException;
import org.apache.james.jmap.routes.BlobResolvers;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.OverQuotaException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.util.ReactorUtils;
import org.apache.james.util.html.HtmlTextExtractor;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsValue;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\r\u0005x!B.]\u0011\u00039g!B5]\u0011\u0003Q\u0007\"B9\u0002\t\u0003\u0011h\u0001B:\u0002\u0001RD!\"!\u0003\u0004\u0005+\u0007I\u0011AA\u0006\u0011)\tYb\u0001B\tB\u0003%\u0011Q\u0002\u0005\u0007c\u000e!\t!!\b\t\u000f\u0005\r2\u0001\"\u0001\u0002&!9\u0011qJ\u0002\u0005\u0002\u0005E\u0003\"CA2\u0007\u0005\u0005I\u0011AA3\u0011%\tIgAI\u0001\n\u0003\tY\u0007C\u0005\u0002\u0002\u000e\t\t\u0011\"\u0011\u0002\u0004\"I\u0011QS\u0002\u0002\u0002\u0013\u0005\u0011q\u0013\u0005\n\u0003?\u001b\u0011\u0011!C\u0001\u0003CC\u0011\"!,\u0004\u0003\u0003%\t%a,\t\u0013\u0005u6!!A\u0005\u0002\u0005}\u0006\"CAe\u0007\u0005\u0005I\u0011IAf\u0011%\tymAA\u0001\n\u0003\n\t\u000eC\u0005\u0002T\u000e\t\t\u0011\"\u0011\u0002V\"I\u0011q[\u0002\u0002\u0002\u0013\u0005\u0013\u0011\\\u0004\n\u0003;\f\u0011\u0011!E\u0001\u0003?4\u0001b]\u0001\u0002\u0002#\u0005\u0011\u0011\u001d\u0005\u0007cV!\t!!?\t\u0013\u0005MW#!A\u0005F\u0005U\u0007\"CA~+\u0005\u0005I\u0011QA\u007f\u0011%\u0011\t!FA\u0001\n\u0003\u0013\u0019\u0001C\u0005\u0003\fU\t\t\u0011\"\u0003\u0003\u000e\u0019I\u0011qC\u0001\u0011\u0002G\u0005\u0011\u0011\u0004\u0004\u0007\u0005+\t\u0001Ia\u0006\t\u0015\teAD!f\u0001\n\u0003\u0011Y\u0002\u0003\u0006\u0003\u001eq\u0011\t\u0012)A\u0005\u0003{A!Ba\b\u001d\u0005+\u0007I\u0011\u0001B\u0011\u0011)\u0011\u0019\u0003\bB\tB\u0003%\u0011\u0011\n\u0005\u0007cr!\tA!\n\t\u0013\u0005\rD$!A\u0005\u0002\t5\u0002\"CA59E\u0005I\u0011\u0001B\u001a\u0011%\u00119\u0004HI\u0001\n\u0003\u0011I\u0004C\u0005\u0002\u0002r\t\t\u0011\"\u0011\u0002\u0004\"I\u0011Q\u0013\u000f\u0002\u0002\u0013\u0005\u0011q\u0013\u0005\n\u0003?c\u0012\u0011!C\u0001\u0005{A\u0011\"!,\u001d\u0003\u0003%\t%a,\t\u0013\u0005uF$!A\u0005\u0002\t\u0005\u0003\"CAe9\u0005\u0005I\u0011\tB#\u0011%\ty\rHA\u0001\n\u0003\n\t\u000eC\u0005\u0002Tr\t\t\u0011\"\u0011\u0002V\"I\u0011q\u001b\u000f\u0002\u0002\u0013\u0005#\u0011J\u0004\n\u0005\u001b\n\u0011\u0011!E\u0001\u0005\u001f2\u0011B!\u0006\u0002\u0003\u0003E\tA!\u0015\t\rE|C\u0011\u0001B-\u0011%\t\u0019nLA\u0001\n\u000b\n)\u000eC\u0005\u0002|>\n\t\u0011\"!\u0003\\!I!\u0011A\u0018\u0002\u0002\u0013\u0005%\u0011\r\u0005\n\u0005\u0017y\u0013\u0011!C\u0005\u0005\u001b1aA!\u001c\u0002\u0001\n=\u0004B\u0003B\rk\tU\r\u0011\"\u0001\u0003\u001c!Q!QD\u001b\u0003\u0012\u0003\u0006I!!\u0010\t\u0015\tETG!f\u0001\n\u0003\u0011\u0019\b\u0003\u0006\u0003|U\u0012\t\u0012)A\u0005\u0005kBa!]\u001b\u0005\u0002\tu\u0004b\u0002BCk\u0011\u0005!q\u0011\u0005\n\u0003G*\u0014\u0011!C\u0001\u0005\u0013C\u0011\"!\u001b6#\u0003%\tAa\r\t\u0013\t]R'%A\u0005\u0002\t=\u0005\"CAAk\u0005\u0005I\u0011IAB\u0011%\t)*NA\u0001\n\u0003\t9\nC\u0005\u0002 V\n\t\u0011\"\u0001\u0003\u0014\"I\u0011QV\u001b\u0002\u0002\u0013\u0005\u0013q\u0016\u0005\n\u0003{+\u0014\u0011!C\u0001\u0005/C\u0011\"!36\u0003\u0003%\tEa'\t\u0013\u0005=W'!A\u0005B\u0005E\u0007\"CAjk\u0005\u0005I\u0011IAk\u0011%\t9.NA\u0001\n\u0003\u0012yjB\u0005\u0003$\u0006\t\t\u0011#\u0001\u0003&\u001aI!QN\u0001\u0002\u0002#\u0005!q\u0015\u0005\u0007c&#\tAa+\t\u0013\u0005M\u0017*!A\u0005F\u0005U\u0007\"CA~\u0013\u0006\u0005I\u0011\u0011BW\u0011%\u0011\t!SA\u0001\n\u0003\u0013\u0019\fC\u0005\u0003\f%\u000b\t\u0011\"\u0003\u0003\u000e\u0019)\u0011\u000e\u0018\u0001\u0003<\"Q!QX(\u0003\u0002\u0003\u0006IAa0\t\u0015\t-wJ!A!\u0002\u0013\u0011i\r\u0003\u0006\u0003Z>\u0013\t\u0011)A\u0005\u00057D!Ba;P\u0005\u0003\u0005\u000b\u0011\u0002Bw\u0011)\u0011Ip\u0014B\u0001B\u0003%!1 \u0005\u000b\u0007\u0007y%\u0011!Q\u0001\n\r\u0015\u0001BB9P\t\u0003\u0019Y\u0001C\u0004\u0004.=#\taa\f\t\u000f\r5r\n\"\u0003\u0004r!911Q(\u0005\n\r\u0015\u0005bBB^\u001f\u0012%1QX\u0001\u0018\u000b6\f\u0017\u000e\\*fi\u000e\u0013X-\u0019;f!\u0016\u0014hm\u001c:nKJT!!\u00180\u0002\r5,G\u000f[8e\u0015\ty\u0006-\u0001\u0003k[\u0006\u0004(BA1c\u0003\u0015Q\u0017-\\3t\u0015\t\u0019G-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0006\u0019qN]4\u0004\u0001A\u0011\u0001.A\u0007\u00029\n9R)\\1jYN+Go\u0011:fCR,\u0007+\u001a:g_JlWM]\n\u0003\u0003-\u0004\"\u0001\\8\u000e\u00035T\u0011A\\\u0001\u0006g\u000e\fG.Y\u0005\u0003a6\u0014a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001h\u0005=\u0019%/Z1uS>t'+Z:vYR\u001c8\u0003B\u0002lkb\u0004\"\u0001\u001c<\n\u0005]l'a\u0002)s_\u0012,8\r\u001e\t\u0004s\u0006\raB\u0001>\u0000\u001d\tYh0D\u0001}\u0015\tih-\u0001\u0004=e>|GOP\u0005\u0002]&\u0019\u0011\u0011A7\u0002\u000fA\f7m[1hK&!\u0011QAA\u0004\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\t\t!\\\u0001\be\u0016\u001cX\u000f\u001c;t+\t\ti\u0001E\u0003z\u0003\u001f\t\u0019\"\u0003\u0003\u0002\u0012\u0005\u001d!aA*fcB\u0019\u0011QC\u000e\u000e\u0003\u0005\u0011ab\u0011:fCRLwN\u001c*fgVdGo\u0005\u0002\u001cW\u0006A!/Z:vYR\u001c\b\u0005\u0006\u0003\u0002 \u0005\u0005\u0002cAA\u000b\u0007!9\u0011\u0011\u0002\u0004A\u0002\u00055\u0011aB2sK\u0006$X\rZ\u000b\u0003\u0003O\u0001R\u0001\\A\u0015\u0003[I1!a\u000bn\u0005\u0019y\u0005\u000f^5p]BA\u0011qFA\u001c\u0003{\tIE\u0004\u0003\u00022\u0005M\u0002CA>n\u0013\r\t)$\\\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00121\b\u0002\u0004\u001b\u0006\u0004(bAA\u001b[B!\u0011qHA#\u001b\t\t\tEC\u0002\u0002Dy\u000bA!\\1jY&!\u0011qIA!\u0005=)U.Y5m\u0007J,\u0017\r^5p]&#\u0007\u0003BA \u0003\u0017JA!!\u0014\u0002B\t)R)\\1jY\u000e\u0013X-\u0019;j_:\u0014Vm\u001d9p]N,\u0017A\u00038pi\u000e\u0013X-\u0019;fIV\u0011\u00111\u000b\t\u0006Y\u0006%\u0012Q\u000b\t\t\u0003_\t9$!\u0010\u0002XA!\u0011\u0011LA0\u001b\t\tYFC\u0002\u0002^y\u000bAaY8sK&!\u0011\u0011MA.\u0005!\u0019V\r^#se>\u0014\u0018\u0001B2paf$B!a\b\u0002h!I\u0011\u0011B\u0005\u0011\u0002\u0003\u0007\u0011QB\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiG\u000b\u0003\u0002\u000e\u0005=4FAA9!\u0011\t\u0019(! \u000e\u0005\u0005U$\u0002BA<\u0003s\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005mT.\u0001\u0006b]:|G/\u0019;j_:LA!a \u0002v\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\t\u0005\u0003\u0002\b\u0006EUBAAE\u0015\u0011\tY)!$\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001f\u000bAA[1wC&!\u00111SAE\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u0014\t\u0004Y\u0006m\u0015bAAO[\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111UAU!\ra\u0017QU\u0005\u0004\u0003Ok'aA!os\"I\u00111V\u0007\u0002\u0002\u0003\u0007\u0011\u0011T\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005E\u0006CBAZ\u0003s\u000b\u0019+\u0004\u0002\u00026*\u0019\u0011qW7\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002<\u0006U&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!1\u0002HB\u0019A.a1\n\u0007\u0005\u0015WNA\u0004C_>dW-\u00198\t\u0013\u0005-v\"!AA\u0002\u0005\r\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!\"\u0002N\"I\u00111\u0016\t\u0002\u0002\u0003\u0007\u0011\u0011T\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011T\u0001\ti>\u001cFO]5oOR\u0011\u0011QQ\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u0005\u00171\u001c\u0005\n\u0003W\u001b\u0012\u0011!a\u0001\u0003G\u000bqb\u0011:fCRLwN\u001c*fgVdGo\u001d\t\u0004\u0003+)2#B\u000b\u0002d\u0006=\b\u0003CAs\u0003W\fi!a\b\u000e\u0005\u0005\u001d(bAAu[\u00069!/\u001e8uS6,\u0017\u0002BAw\u0003O\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82!\u0011\t\t0a>\u000e\u0005\u0005M(\u0002BA{\u0003\u001b\u000b!![8\n\t\u0005\u0015\u00111\u001f\u000b\u0003\u0003?\fQ!\u00199qYf$B!a\b\u0002\u0000\"9\u0011\u0011\u0002\rA\u0002\u00055\u0011aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u000b\u00119\u0001E\u0003m\u0003S\ti\u0001C\u0005\u0003\ne\t\t\u00111\u0001\u0002 \u0005\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t=\u0001\u0003BAD\u0005#IAAa\u0005\u0002\n\n1qJ\u00196fGR\u0014qb\u0011:fCRLwN\\*vG\u000e,7o]\n\u00079-\f\u0019\"\u001e=\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012,\"!!\u0010\u0002\u0013\rd\u0017.\u001a8u\u0013\u0012\u0004\u0013\u0001\u0003:fgB|gn]3\u0016\u0005\u0005%\u0013!\u0003:fgB|gn]3!)\u0019\u00119C!\u000b\u0003,A\u0019\u0011Q\u0003\u000f\t\u000f\te\u0011\u00051\u0001\u0002>!9!qD\u0011A\u0002\u0005%CC\u0002B\u0014\u0005_\u0011\t\u0004C\u0005\u0003\u001a\t\u0002\n\u00111\u0001\u0002>!I!q\u0004\u0012\u0011\u0002\u0003\u0007\u0011\u0011J\u000b\u0003\u0005kQC!!\u0010\u0002p\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u001eU\u0011\tI%a\u001c\u0015\t\u0005\r&q\b\u0005\n\u0003W;\u0013\u0011!a\u0001\u00033#B!!1\u0003D!I\u00111V\u0015\u0002\u0002\u0003\u0007\u00111\u0015\u000b\u0005\u0003\u000b\u00139\u0005C\u0005\u0002,*\n\t\u00111\u0001\u0002\u001aR!\u0011\u0011\u0019B&\u0011%\tY+LA\u0001\u0002\u0004\t\u0019+A\bDe\u0016\fG/[8o'V\u001c7-Z:t!\r\t)bL\n\u0006_\tM\u0013q\u001e\t\u000b\u0003K\u0014)&!\u0010\u0002J\t\u001d\u0012\u0002\u0002B,\u0003O\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\u0011y\u0005\u0006\u0004\u0003(\tu#q\f\u0005\b\u00053\u0011\u0004\u0019AA\u001f\u0011\u001d\u0011yB\ra\u0001\u0003\u0013\"BAa\u0019\u0003lA)A.!\u000b\u0003fA9ANa\u001a\u0002>\u0005%\u0013b\u0001B5[\n1A+\u001e9mKJB\u0011B!\u00034\u0003\u0003\u0005\rAa\n\u0003\u001f\r\u0013X-\u0019;j_:4\u0015-\u001b7ve\u0016\u001cb!N6\u0002\u0014UD\u0018!A3\u0016\u0005\tU\u0004cA=\u0003x%!!\u0011PA\u0004\u0005%!\u0006N]8xC\ndW-\u0001\u0002fAQ1!q\u0010BA\u0005\u0007\u00032!!\u00066\u0011\u001d\u0011IB\u000fa\u0001\u0003{AqA!\u001d;\u0001\u0004\u0011)(A\tbg6+7o]1hKN+G/\u0012:s_J,\"!a\u0016\u0015\r\t}$1\u0012BG\u0011%\u0011I\u0002\u0010I\u0001\u0002\u0004\ti\u0004C\u0005\u0003rq\u0002\n\u00111\u0001\u0003vU\u0011!\u0011\u0013\u0016\u0005\u0005k\ny\u0007\u0006\u0003\u0002$\nU\u0005\"CAV\u0003\u0006\u0005\t\u0019AAM)\u0011\t\tM!'\t\u0013\u0005-6)!AA\u0002\u0005\rF\u0003BAC\u0005;C\u0011\"a+E\u0003\u0003\u0005\r!!'\u0015\t\u0005\u0005'\u0011\u0015\u0005\n\u0003W;\u0015\u0011!a\u0001\u0003G\u000bqb\u0011:fCRLwN\u001c$bS2,(/\u001a\t\u0004\u0003+I5#B%\u0003*\u0006=\bCCAs\u0005+\niD!\u001e\u0003\u0000Q\u0011!Q\u0015\u000b\u0007\u0005\u007f\u0012yK!-\t\u000f\teA\n1\u0001\u0002>!9!\u0011\u000f'A\u0002\tUD\u0003\u0002B[\u0005s\u0003R\u0001\\A\u0015\u0005o\u0003r\u0001\u001cB4\u0003{\u0011)\bC\u0005\u0003\n5\u000b\t\u00111\u0001\u0003\u0000M\u0011qj[\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0003\u0002Ba\u0005\u000fl!Aa1\u000b\u0007\t\u0015g,\u0001\u0003kg>t\u0017\u0002\u0002Be\u0005\u0007\u0014!#R7bS2\u001cV\r^*fe&\fG.\u001b>fe\u0006i!\r\\8c%\u0016\u001cx\u000e\u001c<feN\u0004BAa4\u0003V6\u0011!\u0011\u001b\u0006\u0004\u0005't\u0016A\u0002:pkR,7/\u0003\u0003\u0003X\nE'!\u0004\"m_\n\u0014Vm]8mm\u0016\u00148/A\tii6dG+\u001a=u\u000bb$(/Y2u_J\u0004BA!8\u0003h6\u0011!q\u001c\u0006\u0005\u0005C\u0014\u0019/\u0001\u0003ii6d'b\u0001BsA\u0006!Q\u000f^5m\u0013\u0011\u0011IOa8\u0003#!#X\u000e\u001c+fqR,\u0005\u0010\u001e:bGR|'/\u0001\bnC&d'm\u001c=NC:\fw-\u001a:\u0011\t\t=(Q_\u0007\u0003\u0005cT1Aa=a\u0003\u001di\u0017-\u001b7c_bLAAa>\u0003r\nqQ*Y5mE>DX*\u00198bO\u0016\u0014\u0018!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0003\u0003~\n}X\"\u00010\n\u0007\r\u0005aLA\tK\u001b\u0006\u00036i\u001c8gS\u001e,(/\u0019;j_:\fAcY8oM&<WO]1uS>t'KZ29mI\n\u0004\u0003BA-\u0007\u000fIAa!\u0003\u0002\\\tA\"*\\1q%\u001a\u001c\u0007H\u000e\u001a2\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\u001d\r51qBB\t\u0007'\u0019)ba\u0006\u0004\u001aA\u0011\u0001n\u0014\u0005\b\u0005{3\u0006\u0019\u0001B`\u0011\u001d\u0011YM\u0016a\u0001\u0005\u001bDqA!7W\u0001\u0004\u0011Y\u000eC\u0004\u0003lZ\u0003\rA!<\t\u000f\teh\u000b1\u0001\u0003|\"911\u0001,A\u0002\r\u0015\u0001f\u0001,\u0004\u001eA!1qDB\u0015\u001b\t\u0019\tC\u0003\u0003\u0004$\r\u0015\u0012AB5oU\u0016\u001cGO\u0003\u0002\u0004(\u0005)!.\u0019<bq&!11FB\u0011\u0005\u0019IeN[3di\u000611M]3bi\u0016$ba!\r\u0004^\r\u001d\u0004CBB\u001a\u0007\u0003\u001a)%\u0004\u0002\u00046)!1qGB\u001d\u0003%\u0001XO\u00197jg\",'OC\u0002o\u0007wQA!!\u0018\u0004>)\u00111qH\u0001\be\u0016\f7\r^8s\u0013\u0011\u0019\u0019e!\u000e\u0003\u000bMkuN\\8\u0011\u0007\r\u001d3AD\u0002\u0004J\u0001qAaa\u0013\u0004\\9!1QJB-\u001d\u0011\u0019yea\u0016\u000f\t\rE3Q\u000b\b\u0004w\u000eM\u0013\"A3\n\u0005\r$\u0017BA1c\u0013\ty\u0006-\u0003\u0002^=\"91qL,A\u0002\r\u0005\u0014a\u0002:fcV,7\u000f\u001e\t\u0005\u0003\u007f\u0019\u0019'\u0003\u0003\u0004f\u0005\u0005#aD#nC&d7+\u001a;SKF,Xm\u001d;\t\u000f\r%t\u000b1\u0001\u0004l\u0005qQ.Y5mE>D8+Z:tS>t\u0007\u0003\u0002Bx\u0007[JAaa\u001c\u0003r\nqQ*Y5mE>D8+Z:tS>tG\u0003CB:\u0007o\u001aIh!!\u0011\r\rM2\u0011IB;!\r\u00199e\u0007\u0005\b\u00053A\u0006\u0019AA\u001f\u0011\u001d\u0019y\u0006\u0017a\u0001\u0007w\u0002B!a\u0010\u0004~%!1qPA!\u0005Q)U.Y5m\u0007J,\u0017\r^5p]J+\u0017/^3ti\"91\u0011\u000e-A\u0002\r-\u0014AB1qa\u0016tG\r\u0006\u0006\u0004\b\u000e-5QRBR\u0007K\u0003baa\r\u0004B\r%\u0005cAB$9!9!\u0011D-A\u0002\u0005u\u0002bBBH3\u0002\u00071\u0011S\u0001\u000eCB\u0004XM\u001c3D_6l\u0017M\u001c3\u0011\t\rM5Q\u0014\b\u0005\u0007+\u001bIJ\u0004\u0003\u0004N\r]\u0015b\u0001BzA&!11\u0014By\u00039iUm]:bO\u0016l\u0015M\\1hKJLAaa(\u0004\"\ni\u0011\t\u001d9f]\u0012\u001cu.\\7b]\u0012TAaa'\u0003r\"91\u0011N-A\u0002\r-\u0004bBBT3\u0002\u00071\u0011V\u0001\u000b[\u0006LGNY8y\u0013\u0012\u001c\b#B=\u0004,\u000e=\u0016\u0002BBW\u0003\u000f\u0011A\u0001T5tiB!1\u0011WB\\\u001b\t\u0019\u0019L\u0003\u0003\u00046\nE\u0018!B7pI\u0016d\u0017\u0002BB]\u0007g\u0013\u0011\"T1jY\n|\u00070\u00133\u0002\u001f\u0005\u001c\u0018\t\u001d9f]\u0012\u001cu.\\7b]\u0012$baa0\u0004L\u000e5\u0007cB=\u0004B\u000e\u00157\u0011S\u0005\u0005\u0007\u0007\f9A\u0001\u0004FSRDWM\u001d\t\u0004s\u000e\u001d\u0017\u0002BBe\u0003\u000f\u0011\u0001$\u00137mK\u001e\fG.\u0011:hk6,g\u000e^#yG\u0016\u0004H/[8o\u0011\u001d\u0019yF\u0017a\u0001\u0007wBqaa4[\u0001\u0004\u0019\t.A\u0004nKN\u001c\u0018mZ3\u0011\t\rM7Q\\\u0007\u0003\u0007+TAaa6\u0004Z\u0006\u0019Am\\7\u000b\u0007\rm\u0007-\u0001\u0004nS6,GG[\u0005\u0005\u0007?\u001c)NA\u0004NKN\u001c\u0018mZ3")
public class EmailSetCreatePerformer {
    private final EmailSetSerializer serializer;
    private final BlobResolvers blobResolvers;
    private final HtmlTextExtractor htmlTextExtractor;
    private final MailboxManager mailboxManager;
    private final JMAPConfiguration configuration;

    public SMono<CreationResults> create(EmailSetRequest request, MailboxSession mailboxSession) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)request.create().getOrElse((Function0 & Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        Function1 & Serializable x$1 = (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                EmailCreationId clientId = (EmailCreationId)tuple2._1();
                JsObject json = (JsObject)tuple2._2();
                return (SMono)$this.serializer.deserializeCreationRequest((JsValue)json).fold((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new CreationFailure(clientId, new IllegalArgumentException(e.toString()))), (Function1 & Serializable)creationRequest -> this.create(clientId, (EmailCreationRequest)creationRequest, mailboxSession));
            }
            throw new MatchError((Object)tuple2);
        };
        int x$2 = qual$1.concatMap$default$2();
        return qual$1.concatMap((Function1)x$1, x$2).collectSeq().map((Function1)EmailSetCreatePerformer$CreationResults$.MODULE$);
    }

    private SMono<CreationResult> create(EmailCreationId clientId, EmailCreationRequest request, MailboxSession mailboxSession) {
        List<MailboxId> mailboxIds = request.mailboxIds().value();
        if (mailboxIds.size() != 1) {
            return SMono$.MODULE$.just((Object)new CreationFailure(clientId, new IllegalArgumentException("mailboxIds need to have size 1")));
        }
        return SMono$.MODULE$.fromCallable(() -> request.toMime4JMessage($this.blobResolvers, $this.htmlTextExtractor, mailboxSession)).flatMap((Function1 & Serializable)either -> (SMono)either.fold((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new CreationFailure(clientId, (Throwable)e)), (Function1 & Serializable)message -> (SMono)this.asAppendCommand(request, (Message)message).fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)e), (Function1 & Serializable)appendCommand -> this.append(clientId, (MessageManager.AppendCommand)appendCommand, mailboxSession, mailboxIds)))).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new CreationFailure(clientId, (Throwable)e))).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }

    private SMono<CreationSuccess> append(EmailCreationId clientId, MessageManager.AppendCommand appendCommand, MailboxSession mailboxSession, List<MailboxId> mailboxIds) {
        return SMono$.MODULE$.apply(this.mailboxManager.getMailboxReactive((MailboxId)mailboxIds.head(), mailboxSession)).flatMap((Function1 & Serializable)mailbox -> SMono$.MODULE$.apply(mailbox.appendMessageReactive(appendCommand, mailboxSession)).map((Function1 & Serializable)appendResult -> {
            Option blobId = BlobId$.MODULE$.of(appendResult.getId().getMessageId()).toOption();
            String threadId = ThreadId$.MODULE$.fromJava(appendResult.getThreadId());
            return new CreationSuccess(clientId, new EmailCreationResponse(appendResult.getId().getMessageId(), blobId, threadId, Size$.MODULE$.sanitizeSize(Predef$.MODULE$.Long2long(appendResult.getSize()))));
        }));
    }

    private Either<IllegalArgumentException, MessageManager.AppendCommand> asAppendCommand(EmailCreationRequest request, Message message) {
        return package$.MODULE$.Right().apply((Object)MessageManager.AppendCommand.builder().recent().withFlags((Flags)request.keywords().map((Function1 & Serializable)x$3 -> x$3.asFlags()).getOrElse((Function0 & Serializable)() -> new Flags())).withInternalDate(Date.from(((UTCDate)request.receivedAt().getOrElse((Function0 & Serializable)() -> new UTCDate(ZonedDateTime.now()))).asUTC().toInstant())).build(message)).flatMap((Function1 & Serializable)appendCommand -> (Either)OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional($this.configuration.getMaximumSendSize())).filter((Function1 & Serializable)limit -> BoxesRunTime.boxToBoolean((boolean)EmailSetCreatePerformer.$anonfun$asAppendCommand$5(appendCommand, limit))).map((Function1 & Serializable)limit -> package$.MODULE$.Left().apply((Object)new SizeExceededException(appendCommand.getMsgIn().size(), Predef$.MODULE$.Long2long(limit)))).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Right().apply(appendCommand)));
    }

    public static final /* synthetic */ boolean $anonfun$asAppendCommand$5(MessageManager.AppendCommand appendCommand$2, Long limit) {
        return appendCommand$2.getMsgIn().size() > Predef$.MODULE$.Long2long(limit);
    }

    @Inject
    public EmailSetCreatePerformer(EmailSetSerializer serializer, BlobResolvers blobResolvers, HtmlTextExtractor htmlTextExtractor, MailboxManager mailboxManager, JMAPConfiguration configuration, JmapRfc8621Configuration configurationRfc8621) {
        this.serializer = serializer;
        this.blobResolvers = blobResolvers;
        this.htmlTextExtractor = htmlTextExtractor;
        this.mailboxManager = mailboxManager;
        this.configuration = configuration;
    }

    public static class CreationFailure
    implements CreationResult,
    Product,
    Serializable {
        private final EmailCreationId clientId;
        private final Throwable e;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public EmailCreationId clientId() {
            return this.clientId;
        }

        public Throwable e() {
            return this.e;
        }

        public SetError asMessageSetError() {
            Throwable throwable = this.e();
            if (throwable instanceof MailboxNotFoundException) {
                MailboxNotFoundException mailboxNotFoundException = (MailboxNotFoundException)throwable;
                return SetError$.MODULE$.notFound(new StringBuilder(8).append("Mailbox ").append(mailboxNotFoundException.getMessage()).toString());
            }
            if (throwable instanceof BlobNotFoundException) {
                BlobNotFoundException blobNotFoundException = (BlobNotFoundException)throwable;
                return SetError$.MODULE$.invalidArguments(new StringBuilder(22).append("Attachment not found: ").append(new Refined((Object)blobNotFoundException.blobId().value())).toString(), (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"attachments")).value()))}))));
            }
            if (throwable instanceof SizeExceededException) {
                SizeExceededException sizeExceededException = (SizeExceededException)throwable;
                return SetError$.MODULE$.tooLarge(sizeExceededException.getMessage());
            }
            if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                return SetError$.MODULE$.invalidArguments(illegalArgumentException.getMessage(), SetError$.MODULE$.invalidArguments$default$2());
            }
            if (throwable instanceof OverQuotaException) {
                OverQuotaException overQuotaException = (OverQuotaException)throwable;
                return SetError$.MODULE$.overQuota(overQuotaException.getMessage());
            }
            return SetError$.MODULE$.serverFail(this.e().getMessage());
        }

        public CreationFailure copy(EmailCreationId clientId, Throwable e) {
            return new CreationFailure(clientId, e);
        }

        public EmailCreationId copy$default$1() {
            return this.clientId();
        }

        public Throwable copy$default$2() {
            return this.e();
        }

        public String productPrefix() {
            return "CreationFailure";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.clientId();
                }
                case 1: {
                    return this.e();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CreationFailure;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "clientId";
                }
                case 1: {
                    return "e";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CreationFailure)) return false;
            boolean bl = true;
            if (!bl) return false;
            CreationFailure creationFailure = (CreationFailure)x$1;
            EmailCreationId emailCreationId = this.clientId();
            EmailCreationId emailCreationId2 = creationFailure.clientId();
            if (emailCreationId == null) {
                if (emailCreationId2 != null) {
                    return false;
                }
            } else if (!((Object)emailCreationId).equals(emailCreationId2)) return false;
            Throwable throwable = this.e();
            Throwable throwable2 = creationFailure.e();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!creationFailure.canEqual(this)) return false;
            return true;
        }

        public CreationFailure(EmailCreationId clientId, Throwable e) {
            this.clientId = clientId;
            this.e = e;
            Product.$init$((Product)this);
        }
    }

    public static interface CreationResult {
    }

    public static class CreationResults
    implements Product,
    Serializable {
        private final Seq<CreationResult> results;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Seq<CreationResult> results() {
            return this.results;
        }

        public Option<Map<EmailCreationId, EmailCreationResponse>> created() {
            return Option$.MODULE$.apply((Object)((IterableOnceOps)this.results().flatMap((Function1 & Serializable)x0$1 -> {
                CreationResult creationResult = x0$1;
                if (creationResult instanceof CreationSuccess) {
                    CreationSuccess creationSuccess = (CreationSuccess)creationResult;
                    return new Some((Object)new Tuple2((Object)creationSuccess.clientId(), (Object)creationSuccess.response()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty()));
        }

        public Option<Map<EmailCreationId, SetError>> notCreated() {
            return Option$.MODULE$.apply((Object)((IterableOnceOps)this.results().flatMap((Function1 & Serializable)x0$1 -> {
                CreationResult creationResult = x0$1;
                if (creationResult instanceof CreationFailure) {
                    CreationFailure creationFailure = (CreationFailure)creationResult;
                    return new Some((Object)new Tuple2((Object)creationFailure.clientId(), (Object)creationFailure.asMessageSetError()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.nonEmpty()));
        }

        public CreationResults copy(Seq<CreationResult> results) {
            return new CreationResults(results);
        }

        public Seq<CreationResult> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "CreationResults";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.results();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CreationResults;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "results";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CreationResults)) return false;
            boolean bl = true;
            if (!bl) return false;
            CreationResults creationResults = (CreationResults)x$1;
            Seq<CreationResult> seq = this.results();
            Seq<CreationResult> seq2 = creationResults.results();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!creationResults.canEqual(this)) return false;
            return true;
        }

        public CreationResults(Seq<CreationResult> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class CreationSuccess
    implements CreationResult,
    Product,
    Serializable {
        private final EmailCreationId clientId;
        private final EmailCreationResponse response;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public EmailCreationId clientId() {
            return this.clientId;
        }

        public EmailCreationResponse response() {
            return this.response;
        }

        public CreationSuccess copy(EmailCreationId clientId, EmailCreationResponse response) {
            return new CreationSuccess(clientId, response);
        }

        public EmailCreationId copy$default$1() {
            return this.clientId();
        }

        public EmailCreationResponse copy$default$2() {
            return this.response();
        }

        public String productPrefix() {
            return "CreationSuccess";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.clientId();
                }
                case 1: {
                    return this.response();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CreationSuccess;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "clientId";
                }
                case 1: {
                    return "response";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CreationSuccess)) return false;
            boolean bl = true;
            if (!bl) return false;
            CreationSuccess creationSuccess = (CreationSuccess)x$1;
            EmailCreationId emailCreationId = this.clientId();
            EmailCreationId emailCreationId2 = creationSuccess.clientId();
            if (emailCreationId == null) {
                if (emailCreationId2 != null) {
                    return false;
                }
            } else if (!((Object)emailCreationId).equals(emailCreationId2)) return false;
            EmailCreationResponse emailCreationResponse = this.response();
            EmailCreationResponse emailCreationResponse2 = creationSuccess.response();
            if (emailCreationResponse == null) {
                if (emailCreationResponse2 != null) {
                    return false;
                }
            } else if (!((Object)emailCreationResponse).equals(emailCreationResponse2)) return false;
            if (!creationSuccess.canEqual(this)) return false;
            return true;
        }

        public CreationSuccess(EmailCreationId clientId, EmailCreationResponse response) {
            this.clientId = clientId;
            this.response = response;
            Product.$init$((Product)this);
        }
    }
}

