/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib.jmx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.ConnectHandler;
import org.apache.james.protocols.api.handler.ExtensibleHandler;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.api.handler.ProtocolHandlerResultHandler;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.lib.jmx.ConnectHandlerStats;

public abstract class AbstractConnectHandlerResultJMXMonitor<R extends Response, S extends ProtocolSession>
implements ProtocolHandlerResultHandler<R, S>,
ExtensibleHandler,
ProtocolHandler {
    private final Map<String, ConnectHandlerStats> cStats = new HashMap<String, ConnectHandlerStats>();
    private String jmxName;

    public void init(Configuration config) throws ConfigurationException {
        this.jmxName = config.getString("jmxName", this.getDefaultJMXName());
    }

    public void destroy() {
        for (ConnectHandlerStats connectHandlerStats : this.cStats.values()) {
            connectHandlerStats.dispose();
        }
    }

    public Response onResponse(ProtocolSession session, Response response, long executionTime, ProtocolHandler handler) {
        if (handler instanceof ConnectHandler) {
            this.cStats.get(handler.getClass().getName()).increment(response);
        }
        return response;
    }

    public List<Class<?>> getMarkerInterfaces() {
        ArrayList marker = new ArrayList();
        marker.add(ConnectHandler.class);
        return marker;
    }

    public void wireExtensions(Class<?> interfaceName, List<?> extension) throws WiringException {
        if (interfaceName.equals(ConnectHandler.class)) {
            for (Object anExtension : extension) {
                ConnectHandler c = (ConnectHandler)anExtension;
                if (this.equals(c)) continue;
                String cName = c.getClass().getName();
                try {
                    this.cStats.put(cName, new ConnectHandlerStats(this.jmxName, cName));
                }
                catch (Exception e) {
                    throw new WiringException("Unable to wire Hooks", (Throwable)e);
                }
            }
        }
    }

    protected abstract String getDefaultJMXName();
}

