/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.ApiClient;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch.core.SearchShardsRequest;
import org.opensearch.client.opensearch.core.SearchShardsResponse;
import org.opensearch.client.opensearch.ml.OpenSearchMlAsyncClient;
import org.opensearch.client.opensearch.search_pipeline.OpenSearchSearchPipelineAsyncClient;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.TransportOptions;
import org.opensearch.client.util.ObjectBuilder;

public abstract class OpenSearchAsyncClientBase<Self extends OpenSearchAsyncClientBase<Self>>
extends ApiClient<OpenSearchTransport, Self> {
    public OpenSearchAsyncClientBase(OpenSearchTransport transport, @Nullable TransportOptions transportOptions) {
        super(transport, transportOptions);
    }

    public OpenSearchMlAsyncClient ml() {
        return new OpenSearchMlAsyncClient((OpenSearchTransport)this.transport, this.transportOptions);
    }

    public OpenSearchSearchPipelineAsyncClient searchPipeline() {
        return new OpenSearchSearchPipelineAsyncClient((OpenSearchTransport)this.transport, this.transportOptions);
    }

    public CompletableFuture<SearchShardsResponse> searchShards(SearchShardsRequest request) throws IOException, OpenSearchException {
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, SearchShardsRequest._ENDPOINT, this.transportOptions);
    }

    public final CompletableFuture<SearchShardsResponse> searchShards(Function<SearchShardsRequest.Builder, ObjectBuilder<SearchShardsRequest>> fn) throws IOException, OpenSearchException {
        return this.searchShards(fn.apply(new SearchShardsRequest.Builder()).build());
    }

    public final CompletableFuture<SearchShardsResponse> searchShards() throws IOException, OpenSearchException {
        return this.searchShards(new SearchShardsRequest.Builder().build());
    }
}

