/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.postgres;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.rrt.lib.MappingsImpl;
import org.apache.james.rrt.postgres.PostgresRecipientRewriteTableDataDefinition;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresRecipientRewriteTableDAO {
    private final PostgresExecutor postgresExecutor;

    @Inject
    public PostgresRecipientRewriteTableDAO(PostgresExecutor postgresExecutor) {
        this.postgresExecutor = postgresExecutor;
    }

    public Mono<Void> addMapping(MappingSource source, Mapping mapping) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresRecipientRewriteTableDataDefinition.PostgresRecipientRewriteTableTable.TABLE_NAME, PostgresRecipientRewriteTableDataDefinition.PostgresRecipientRewriteTableTable.USERNAME, PostgresRecipientRewriteTableDataDefinition.PostgresRecipientRewriteTableTable.DOMAIN_NAME, PostgresRecipientRewriteTableDataDefinition.PostgresRecipientRewriteTableTable.TARGET_ADDRESS).values((Object)source.getFixedUser(), (Object)source.getFixedDomain(), (Object)mapping.asString()).onConflictOnConstraint(PostgresRecipientRewriteTableDataDefinition.PostgresRecipientRewriteTableTable.PK_CONSTRAINT_NAME).doUpdate().set(PostgresRecipientRewriteTableDataDefinition.PostgresRecipientRewriteTableTable.TARGET_ADDRESS, (Object)mapping.asString())));
    }

    public Mono<Void> removeMapping(MappingSource source, Mapping mapping) {
        return this.postgresExecutor.executeVoid(dsl -> Mono.from((Publisher)dsl.deleteFrom(PostgresRecipientRewriteTableDataDefinition.PostgresRecipientRewriteTableTable.TABLE_NAME).where(PostgresRecipientRewriteTableDataDefinition.PostgresRecipientRewriteTableTable.USERNAME.eq((Object)source.getFixedUser())).and(PostgresRecipientRewriteTableDataDefinition.PostgresRecipientRewriteTableTable.DOMAIN_NAME.eq((Object)source.getFixedDomain())).and(PostgresRecipientRewriteTableDataDefinition.PostgresRecipientRewriteTableTable.TARGET_ADDRESS.eq((Object)mapping.asString()))));
    }

    public Mono<Mappings> getMappings(MappingSource source) {
        return this.postgresExecutor.executeRows(dsl -> Flux.from((Publisher)dsl.selectFrom(PostgresRecipientRewriteTableDataDefinition.PostgresRecipientRewriteTableTable.TABLE_NAME).where(PostgresRecipientRewriteTableDataDefinition.PostgresRecipientRewriteTableTable.USERNAME.eq((Object)source.getFixedUser())).and(PostgresRecipientRewriteTableDataDefinition.PostgresRecipientRewriteTableTable.DOMAIN_NAME.eq((Object)source.getFixedDomain())))).map(record -> (String)record.get(PostgresRecipientRewriteTableDataDefinition.PostgresRecipientRewriteTableTable.TARGET_ADDRESS)).collect(ImmutableList.toImmutableList()).map(MappingsImpl::fromCollection);
    }

    public Flux<Pair<MappingSource, Mapping>> getAllMappings() {
        return this.postgresExecutor.executeRows(dsl -> Flux.from((Publisher)dsl.selectFrom(PostgresRecipientRewriteTableDataDefinition.PostgresRecipientRewriteTableTable.TABLE_NAME))).map(record -> Pair.of((Object)MappingSource.fromUser((String)((String)record.get(PostgresRecipientRewriteTableDataDefinition.PostgresRecipientRewriteTableTable.USERNAME)), (String)((String)record.get(PostgresRecipientRewriteTableDataDefinition.PostgresRecipientRewriteTableTable.DOMAIN_NAME))), (Object)Mapping.of((String)((String)record.get(PostgresRecipientRewriteTableDataDefinition.PostgresRecipientRewriteTableTable.TARGET_ADDRESS)))));
    }

    public Flux<MappingSource> getSources(Mapping mapping) {
        return this.postgresExecutor.executeRows(dsl -> Flux.from((Publisher)dsl.selectFrom(PostgresRecipientRewriteTableDataDefinition.PostgresRecipientRewriteTableTable.TABLE_NAME).where(PostgresRecipientRewriteTableDataDefinition.PostgresRecipientRewriteTableTable.TARGET_ADDRESS.eq((Object)mapping.asString())))).map(record -> MappingSource.fromUser((String)((String)record.get(PostgresRecipientRewriteTableDataDefinition.PostgresRecipientRewriteTableTable.USERNAME)), (String)((String)record.get(PostgresRecipientRewriteTableDataDefinition.PostgresRecipientRewriteTableTable.DOMAIN_NAME))));
    }
}

