/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.apache.commons.io.FilenameUtils;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.testbeans.gui.FieldStringEditor;
import org.apache.jmeter.testbeans.gui.GenericTestBeanCustomizer;
import org.apache.jmeter.testbeans.gui.WrapperEditor;
import org.apache.jmeter.util.JMeterUtils;

public class FileEditor
implements PropertyEditor,
ActionListener {
    private final JPanel panel;
    private final PropertyEditor editor;

    @Deprecated
    public FileEditor() throws IntrospectionException {
        this(new PropertyDescriptor("dummy", null, null));
    }

    public FileEditor(PropertyDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException("Descriptor must not be null");
        }
        JButton button = new JButton(JMeterUtils.getResString("browse"));
        button.addActionListener(this);
        boolean notNull = GenericTestBeanCustomizer.notNull(descriptor);
        boolean notExpression = GenericTestBeanCustomizer.notExpression(descriptor);
        boolean notOther = GenericTestBeanCustomizer.notOther(descriptor);
        Object defaultValue = descriptor.getValue("default");
        FieldStringEditor cse = new FieldStringEditor();
        this.editor = new WrapperEditor(this, new PropertyEditorSupport(), cse, !notNull, !notExpression, !notOther, defaultValue == null ? "" : defaultValue);
        this.panel = new JPanel(new BorderLayout(5, 0));
        this.panel.add(this.editor.getCustomEditor(), "Center");
        this.panel.add((Component)button, "East");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = FileDialoger.promptToOpenFile();
        if (chooser == null) {
            return;
        }
        this.setValue(FileEditor.toUnix(chooser.getSelectedFile()));
    }

    private static String toUnix(File selectedFile) {
        if (File.separatorChar == '\\') {
            return FilenameUtils.separatorsToUnix((String)selectedFile.getPath());
        }
        return selectedFile.getPath();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.editor.addPropertyChangeListener(listener);
    }

    @Override
    public String getAsText() {
        return this.editor.getAsText();
    }

    @Override
    public Component getCustomEditor() {
        return this.panel;
    }

    @Override
    public String getJavaInitializationString() {
        return this.editor.getJavaInitializationString();
    }

    @Override
    public String[] getTags() {
        return this.editor.getTags();
    }

    @Override
    public Object getValue() {
        return this.editor.getValue();
    }

    @Override
    public boolean isPaintable() {
        return this.editor.isPaintable();
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        this.editor.paintValue(gfx, box);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.editor.removePropertyChangeListener(listener);
    }

    @Override
    public void setAsText(String text) {
        this.editor.setAsText(text);
    }

    @Override
    public void setValue(Object value) {
        this.editor.setValue(value);
    }

    @Override
    public boolean supportsCustomEditor() {
        return this.editor.supportsCustomEditor();
    }
}

